/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public abstract class SingleSelectBoxDisplay2<K, T> {
    private List<SelectBoxItemDisplay2<K, T>> formattedModel = this.getInitialList();
    private int selectedIndex;

    public SingleSelectBoxDisplay2() {
        if (this.formattedModel == null) {
            this.formattedModel = new ArrayList<SelectBoxItemDisplay2<K, T>>();
        }
        this.selectedIndex = -1;
    }

    protected void addItems(List<SelectBoxItemDisplay2<K, T>> formattedModel) {
    }

    protected String getBlankText() {
        return "";
    }

    protected List<SelectBoxItemDisplay2<K, T>> getInitialList() {
        return null;
    }

    protected abstract K getKey(T var1);

    protected Comparator<SelectBoxItemDisplay2<K, T>> getSortComparator() {
        return new TextComparator();
    }

    protected abstract String getText(T var1);

    protected abstract String getValue(K var1);

    protected boolean hasBlankValue() {
        return false;
    }

    protected boolean isAllowed(T item) {
        return true;
    }

    public void addBlankValue() {
        SelectBoxItemDisplay2<Object, Object> formattedItem = new SelectBoxItemDisplay2<Object, Object>("", this.getBlankText(), null, null);
        this.formattedModel.add(0, formattedItem);
    }

    public List<SelectBoxItemDisplay2<K, T>> getList() {
        return this.formattedModel;
    }

    public SelectBoxItemDisplay2<K, T> getSelectedItem() {
        if (this.selectedIndex > -1) {
            return this.formattedModel.get(this.selectedIndex);
        }
        return null;
    }

    public void setList(List<SelectBoxItemDisplay2<K, T>> value) {
        this.formattedModel = value;
    }

    public void setModel(Collection<T> model) {
        this.formattedModel.clear();
        if (model != null) {
            for (T item : model) {
                if (!this.isAllowed(item)) continue;
                K key = this.getKey(item);
                String value = this.getValue(key);
                String text = this.getText(item);
                SelectBoxItemDisplay2<K, T> formattedItem = new SelectBoxItemDisplay2<K, T>(value, text, key, item);
                this.formattedModel.add(formattedItem);
            }
        }
        Collections.sort(this.formattedModel, this.getSortComparator());
        this.addItems(this.formattedModel);
        if (this.hasBlankValue()) {
            this.formattedModel.add(0, new SelectBoxItemDisplay2<Object, Object>("", this.getBlankText(), null, null));
        }
    }

    public void setSelectedFormattedValue(String value) {
        SelectBoxItemDisplay2<K, T> item;
        if (this.selectedIndex > -1) {
            item = this.formattedModel.get(this.selectedIndex);
            item.setSelected(false);
        }
        this.selectedIndex = -1;
        if (value != null && value.length() > 0) {
            ListIterator<SelectBoxItemDisplay2<K, T>> iter = this.formattedModel.listIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (!item.getValue().equals(value)) continue;
                this.selectedIndex = iter.previousIndex();
                item.setSelected(true);
                found = true;
            }
        }
    }

    public void setSelectedFormattedValueWithConversionError(String value, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedFormattedValue(value);
        }
    }

    public void setSelectedValue(K key) {
        SelectBoxItemDisplay2<K, T> item;
        if (this.selectedIndex > -1) {
            item = this.formattedModel.get(this.selectedIndex);
            item.setSelected(false);
        }
        this.selectedIndex = -1;
        if (key != null) {
            ListIterator<SelectBoxItemDisplay2<K, T>> iter = this.formattedModel.listIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (!key.equals(item.getKey())) continue;
                this.selectedIndex = iter.previousIndex();
                item.setSelected(true);
                found = true;
            }
        }
    }

    public void setSelectedValueWithConversionError(K key, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedValue(key);
        }
    }

    public class TextComparator
    implements Comparator<SelectBoxItemDisplay2<K, T>> {
        @Override
        public int compare(SelectBoxItemDisplay2<K, T> o1, SelectBoxItemDisplay2<K, T> o2) {
            return o1.getText().compareToIgnoreCase(o2.getText());
        }
    }
}

