/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public abstract class SingleSelectBoxDisplay<T> {
    private static Logger LOG = LogManager.getLogger(SingleSelectBoxDisplay.class);
    private List<SelectBoxItemDisplay<T>> formattedModel = this.getInitialList();
    private int selectedIndex;

    public SingleSelectBoxDisplay() {
        if (this.formattedModel == null) {
            this.formattedModel = new ArrayList<SelectBoxItemDisplay<T>>();
        }
        this.selectedIndex = -1;
    }

    protected void addItems(List<SelectBoxItemDisplay<T>> formattedModel) {
    }

    protected String getBlankText() {
        return "";
    }

    protected List<SelectBoxItemDisplay<T>> getInitialList() {
        return null;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Comparator<SelectBoxItemDisplay<T>> getSortComparator() {
        return new TextComparator();
    }

    protected abstract String getText(T var1);

    protected abstract String getValue(T var1);

    protected boolean hasBlankValue() {
        return false;
    }

    protected boolean isAllowed(T item) {
        return true;
    }

    public void addBlankValue() {
        SelectBoxItemDisplay<Object> formattedItem = new SelectBoxItemDisplay<Object>("", this.getBlankText(), null);
        this.formattedModel.add(0, formattedItem);
    }

    public List<SelectBoxItemDisplay<T>> getList() {
        return this.formattedModel;
    }

    public SelectBoxItemDisplay<T> getSelectedItem() {
        if (this.selectedIndex > -1) {
            return this.formattedModel.get(this.selectedIndex);
        }
        return null;
    }

    public void setList(List<SelectBoxItemDisplay<T>> value) {
        this.formattedModel = value;
    }

    public void setModel(Collection<T> model) {
        try {
            this.formattedModel.clear();
            if (model != null) {
                for (T item : model) {
                    if (!this.isAllowed(item)) continue;
                    String value = this.getValue(item);
                    String text = this.getText(item);
                    SelectBoxItemDisplay<T> formattedItem = new SelectBoxItemDisplay<T>(value, text, item);
                    this.formattedModel.add(formattedItem);
                }
            }
            Collections.sort(this.formattedModel, this.getSortComparator());
            this.addItems(this.formattedModel);
            if (this.hasBlankValue()) {
                this.formattedModel.add(0, new SelectBoxItemDisplay<Object>("", this.getBlankText(), null));
            }
        }
        catch (Exception e) {
            LOG.error("Setup of JSP view helper failed", (Throwable)e);
        }
    }

    public void setSelectedValue(String value) {
        SelectBoxItemDisplay<T> item;
        if (this.selectedIndex > -1) {
            item = this.formattedModel.get(this.selectedIndex);
            item.setSelected(false);
        }
        this.selectedIndex = -1;
        if (value != null && value.length() > 0) {
            ListIterator<SelectBoxItemDisplay<T>> iter = this.formattedModel.listIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (!item.getValue().equals(value)) continue;
                this.selectedIndex = iter.previousIndex();
                item.setSelected(true);
                found = true;
            }
        }
    }

    public class TextComparator
    implements Comparator<SelectBoxItemDisplay<T>> {
        @Override
        public int compare(SelectBoxItemDisplay<T> o1, SelectBoxItemDisplay<T> o2) {
            return o1.getText().compareToIgnoreCase(o2.getText());
        }
    }
}

