/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public abstract class MultiSelectBoxDisplay<K, T> {
    private List<SelectBoxItemDisplay2<K, T>> formattedModel = new ArrayList<SelectBoxItemDisplay2<K, T>>();
    private Map<K, SelectBoxItemDisplay2<K, T>> formattedModelTableByKey = new HashMap<K, SelectBoxItemDisplay2<K, T>>();
    private Map<String, SelectBoxItemDisplay2<K, T>> formattedModelTableByValue = new HashMap<String, SelectBoxItemDisplay2<K, T>>();

    protected void addItems(List<SelectBoxItemDisplay2<K, T>> formattedModel) {
    }

    protected abstract K getKey(T var1);

    protected Comparator<SelectBoxItemDisplay2<K, T>> getSortComparator() {
        return new TextComparator();
    }

    protected abstract String getText(T var1);

    protected abstract String getValue(T var1);

    protected boolean isAllowed(T item) {
        return true;
    }

    public List<SelectBoxItemDisplay2<K, T>> getList() {
        return this.formattedModel;
    }

    public Collection<SelectBoxItemDisplay2<K, T>> getSelectedItems() {
        ArrayList<SelectBoxItemDisplay2<K, T>> result = new ArrayList<SelectBoxItemDisplay2<K, T>>();
        for (SelectBoxItemDisplay2<K, T> item : this.formattedModel) {
            if (!item.getSelected()) continue;
            result.add(item);
        }
        return result;
    }

    public void setList(List<SelectBoxItemDisplay2<K, T>> value) {
        this.formattedModel = value;
    }

    public void setModel(Collection<T> model) {
        this.formattedModel.clear();
        if (model != null) {
            for (T t : model) {
                if (!this.isAllowed(t)) continue;
                K key = this.getKey(t);
                String value = this.getValue(t);
                String text = this.getText(t);
                SelectBoxItemDisplay2<K, T> formattedItem = new SelectBoxItemDisplay2<K, T>(value, text, key, t);
                this.formattedModel.add(formattedItem);
            }
        }
        Collections.sort(this.formattedModel, this.getSortComparator());
        this.addItems(this.formattedModel);
        this.formattedModelTableByKey.clear();
        this.formattedModelTableByValue.clear();
        for (SelectBoxItemDisplay2 selectBoxItemDisplay2 : this.formattedModel) {
            this.formattedModelTableByKey.put(selectBoxItemDisplay2.getKey(), selectBoxItemDisplay2);
            this.formattedModelTableByValue.put(selectBoxItemDisplay2.getValue(), selectBoxItemDisplay2);
        }
    }

    public void setSelectedFormattedValues(Collection<String> values) {
        for (SelectBoxItemDisplay2<K, T> item2 : this.formattedModel) {
            item2.setSelected(false);
        }
        if (values != null) {
            for (String value : values) {
                SelectBoxItemDisplay2<K, T> item = this.formattedModelTableByValue.get(value);
                if (item == null) continue;
                item.setSelected(true);
            }
        }
    }

    public void setSelectedValues(Collection<K> keys) {
        for (SelectBoxItemDisplay2<K, T> item2 : this.formattedModel) {
            item2.setSelected(false);
        }
        if (keys != null) {
            for (SelectBoxItemDisplay2<K, T> key : keys) {
                SelectBoxItemDisplay2<K, T> item = this.formattedModelTableByKey.get(key);
                if (item == null) continue;
                item.setSelected(true);
            }
        }
    }

    public class TextComparator
    implements Comparator<SelectBoxItemDisplay2<K, T>> {
        @Override
        public int compare(SelectBoxItemDisplay2<K, T> o1, SelectBoxItemDisplay2<K, T> o2) {
            return o1.getText().compareToIgnoreCase(o2.getText());
        }
    }
}

