/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.view.SelectBoxGroupDisplay;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public abstract class GroupedSingleSelectBoxDisplay<K, T, G> {
    private List<SelectBoxGroupDisplay<K, T, G>> formattedModel = this.getInitialList();
    private Map<K, SelectBoxItemDisplay2<K, T>> formattedModelTableByKey;
    private Map<String, SelectBoxItemDisplay2<K, T>> formattedModelTableByValue;
    private K selectedKey;
    private String selectedValue;

    public GroupedSingleSelectBoxDisplay() {
        if (this.formattedModel == null) {
            this.formattedModel = new ArrayList<SelectBoxGroupDisplay<K, T, G>>();
        }
        this.selectedValue = null;
    }

    protected void addItems(List<SelectBoxGroupDisplay<K, T, G>> formattedModel) {
    }

    protected String getBlankText() {
        return "";
    }

    protected abstract G getGroup(T var1);

    protected abstract String getGroupLabel(G var1);

    protected Comparator<SelectBoxGroupDisplay<K, T, G>> getGroupSortComparator() {
        return (o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText());
    }

    protected List<SelectBoxGroupDisplay<K, T, G>> getInitialList() {
        return null;
    }

    public abstract K getKey(T var1);

    protected Comparator<SelectBoxItemDisplay2<K, T>> getSortComparator() {
        return (o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText());
    }

    protected abstract String getText(T var1);

    protected abstract String getValue(T var1);

    protected boolean hasBlankValue() {
        return false;
    }

    protected boolean isAllowed(T item) {
        return true;
    }

    protected SelectBoxItemDisplay2<K, T> makeSelectBoxItemDisplay(String value, String text, K key, T data) {
        return new SelectBoxItemDisplay2<K, T>(value, text, key, data);
    }

    public void addBlankValue() {
        SelectBoxGroupDisplay groupDisplay = new SelectBoxGroupDisplay("", null);
        groupDisplay.getChildren().add(this.makeSelectBoxItemDisplay("", this.getBlankText(), null, null));
        this.formattedModel.add(0, groupDisplay);
    }

    public List<SelectBoxGroupDisplay<K, T, G>> getList() {
        return this.formattedModel;
    }

    public SelectBoxItemDisplay2<K, T> getSelectedItem() {
        if (this.selectedKey != null) {
            return this.formattedModelTableByKey.get(this.selectedKey);
        }
        return null;
    }

    public void setList(List<SelectBoxGroupDisplay<K, T, G>> value) {
        this.formattedModel = value;
    }

    public void setModel(Collection<T> model) {
        HashMap workingGroups = new HashMap();
        this.formattedModelTableByKey = new HashMap<K, SelectBoxItemDisplay2<K, T>>();
        this.formattedModelTableByValue = new HashMap<String, SelectBoxItemDisplay2<K, T>>();
        this.selectedValue = null;
        if (model != null) {
            for (T t : model) {
                if (!this.isAllowed(t)) continue;
                K key = this.getKey(t);
                String value = this.getValue(t);
                String text = this.getText(t);
                G group = this.getGroup(t);
                String groupLabel = this.getGroupLabel(group);
                SelectBoxGroupDisplay groupDisplay = (SelectBoxGroupDisplay)workingGroups.get(groupLabel);
                if (groupDisplay == null) {
                    groupDisplay = new SelectBoxGroupDisplay(groupLabel, group);
                    workingGroups.put(groupLabel, groupDisplay);
                }
                SelectBoxItemDisplay2<K, T> formattedItem = this.makeSelectBoxItemDisplay(value, text, key, t);
                groupDisplay.getChildren().add(formattedItem);
                this.formattedModelTableByKey.put(key, formattedItem);
                this.formattedModelTableByValue.put(value, formattedItem);
            }
        }
        this.formattedModel = new ArrayList<SelectBoxGroupDisplay<K, T, G>>();
        Comparator<SelectBoxItemDisplay2<K, T>> childComparator = this.getSortComparator();
        Comparator<SelectBoxGroupDisplay<K, T, G>> groupComparator = this.getGroupSortComparator();
        for (Map.Entry entry : workingGroups.entrySet()) {
            Collections.sort(((SelectBoxGroupDisplay)entry.getValue()).getChildren(), childComparator);
            this.formattedModel.add((SelectBoxGroupDisplay)entry.getValue());
        }
        Collections.sort(this.formattedModel, groupComparator);
        this.addItems(this.formattedModel);
        if (this.hasBlankValue()) {
            this.addBlankValue();
        }
    }

    public void setSelectedFormattedValueWithConversionError(String value, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedFormattedValue(value);
        }
    }

    public void setSelectedValueWithConversionError(K key, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedValue(key);
        }
    }

    public void setSelectedFormattedValue(String value) {
        SelectBoxItemDisplay2<K, T> item;
        if (this.selectedValue != null) {
            item = this.formattedModelTableByValue.get(this.selectedValue);
            item.setSelected(false);
        }
        this.selectedKey = null;
        this.selectedValue = null;
        if (value != null && value.length() > 0 && (item = this.formattedModelTableByValue.get(value)) != null) {
            item.setSelected(true);
            this.selectedKey = item.getKey();
            this.selectedValue = item.getValue();
        }
    }

    public void setSelectedValue(K key) {
        SelectBoxItemDisplay2<K, T> item;
        if (this.selectedKey != null) {
            item = this.formattedModelTableByKey.get(this.selectedKey);
            item.setSelected(false);
        }
        this.selectedKey = null;
        this.selectedValue = null;
        if (key != null && (item = this.formattedModelTableByKey.get(key)) != null) {
            item.setSelected(true);
            this.selectedKey = item.getKey();
            this.selectedValue = item.getValue();
        }
    }
}

