/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.view.SelectBoxGroupDisplay;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public abstract class GroupedEnumSingleSelectBoxDisplay<E extends Enum<E>> {
    private List<SelectBoxGroupDisplay<E, E, Integer>> formattedModel;
    private Map<E, SelectBoxItemDisplay2<E, E>> formattedModelTableByKey;
    private Map<String, SelectBoxItemDisplay2<E, E>> formattedModelTableByValue;
    private E selectedKey;
    private String selectedValue;

    public GroupedEnumSingleSelectBoxDisplay() {
        SelectBoxGroupDisplay group;
        HashMap workingGroups = new HashMap();
        this.formattedModelTableByKey = new HashMap<E, SelectBoxItemDisplay2<E, E>>();
        this.formattedModelTableByValue = new HashMap<String, SelectBoxItemDisplay2<E, E>>();
        this.selectedKey = null;
        this.selectedValue = null;
        for (Enum item : this.getEnumValues()) {
            if (!this.isAllowed(item)) continue;
            String value = this.getValue(item);
            String text = this.getText(item);
            int groupOrder = this.getGroupOrder(item);
            group = (SelectBoxGroupDisplay)workingGroups.get(groupOrder);
            if (group == null) {
                String groupLabel = this.getGroupLabel(groupOrder);
                group = new SelectBoxGroupDisplay(groupLabel, groupOrder);
                workingGroups.put(groupOrder, group);
            }
            SelectBoxItemDisplay2<Enum, Enum> formattedItem = this.makeSelectBoxItemDisplay(value, text, item);
            group.getChildren().add(formattedItem);
            this.formattedModelTableByKey.put(item, formattedItem);
            this.formattedModelTableByValue.put(value, formattedItem);
        }
        this.formattedModel = new ArrayList<SelectBoxGroupDisplay<E, E, Integer>>();
        Comparator<SelectBoxItemDisplay2<E, E>> sortComparator = this.getSortComparator();
        for (Map.Entry entry : workingGroups.entrySet()) {
            Collections.sort(((SelectBoxGroupDisplay)entry.getValue()).getChildren(), sortComparator);
            this.formattedModel.add((SelectBoxGroupDisplay)entry.getValue());
        }
        Collections.sort(this.formattedModel, (o1, o2) -> (Integer)o1.getData() - (Integer)o2.getData());
        this.addItems(this.formattedModel);
        if (this.hasBlankValue()) {
            group = new SelectBoxGroupDisplay("", -1);
            group.getChildren().add(this.makeSelectBoxItemDisplay("", this.getBlankText(), null));
            this.formattedModel.add(0, group);
        }
    }

    protected void addItems(List<SelectBoxGroupDisplay<E, E, Integer>> formattedModel) {
    }

    protected String getBlankText() {
        return "";
    }

    protected abstract E[] getEnumValues();

    protected abstract String getGroupLabel(int var1);

    protected abstract int getGroupOrder(E var1);

    protected Comparator<SelectBoxItemDisplay2<E, E>> getSortComparator() {
        return (o1, o2) -> ((Enum)o1.getData()).compareTo((Enum)o2.getData());
    }

    protected String getText(E item) {
        return ((Enum)item).toString();
    }

    protected String getValue(E item) {
        return ((Enum)item).toString();
    }

    protected boolean hasBlankValue() {
        return false;
    }

    protected boolean isAllowed(E item) {
        return true;
    }

    protected SelectBoxItemDisplay2<E, E> makeSelectBoxItemDisplay(String value, String text, E data) {
        return new SelectBoxItemDisplay2<E, E>(value, text, data, data);
    }

    public List<SelectBoxGroupDisplay<E, E, Integer>> getList() {
        return this.formattedModel;
    }

    public void setList(List<SelectBoxGroupDisplay<E, E, Integer>> value) {
        this.formattedModel = value;
    }

    public void setSelectedFormattedValueWithConversionError(String value, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedFormattedValue(value);
        }
    }

    public void setSelectedValueWithConversionError(E key, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedValue(key);
        }
    }

    public void setSelectedFormattedValue(String value) {
        SelectBoxItemDisplay2<E, E> item;
        if (this.selectedValue != null) {
            item = this.formattedModelTableByValue.get(this.selectedValue);
            item.setSelected(false);
        }
        this.selectedKey = null;
        this.selectedValue = null;
        if (value != null && value.length() > 0 && (item = this.formattedModelTableByValue.get(value)) != null) {
            item.setSelected(true);
            this.selectedKey = (Enum)item.getKey();
            this.selectedValue = item.getValue();
        }
    }

    public void setSelectedValue(E key) {
        SelectBoxItemDisplay2<E, E> item;
        if (this.selectedKey != null) {
            item = this.formattedModelTableByKey.get(this.selectedKey);
            item.setSelected(false);
        }
        this.selectedKey = null;
        this.selectedValue = null;
        if (key != null && (item = this.formattedModelTableByKey.get(key)) != null) {
            item.setSelected(true);
            this.selectedKey = (Enum)item.getKey();
            this.selectedValue = item.getValue();
        }
    }
}

