/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import java.util.List;

public class FormattedListDisplay<T> {
    private List<T> list;
    private boolean pageMode;
    private int page;
    private int pageSize;
    private int totalItems;
    private int totalPages;
    private int selectedIndex;

    public int getEndMasterIndex() {
        if (this.pageMode && this.page == this.totalPages) {
            return this.totalItems - 1;
        }
        if (this.pageMode && this.list.size() > 0) {
            return this.page * this.pageSize - 1;
        }
        if (this.list.size() == 0) {
            return -1;
        }
        return this.list.size() - 1;
    }

    public boolean getHasSelectedItem() {
        return this.selectedIndex >= 0;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> value) {
        this.list = value;
    }

    public int getListSize() {
        return this.list.size();
    }

    public boolean getPageMode() {
        return this.pageMode;
    }

    public void setPageMode(boolean value) {
        this.pageMode = value;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int value) {
        this.page = value;
    }

    public int getPageEndIndex() {
        if (this.pageMode && this.page == this.totalPages) {
            return this.totalItems - 1;
        }
        if (this.pageMode && this.list.size() > 0) {
            return this.page * this.pageSize - 1;
        }
        if (this.list.size() == 0) {
            return -1;
        }
        return this.list.size() - 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int value) {
        this.pageSize = value;
    }

    public int getPageStartIndex() {
        if (this.pageMode && this.list.size() > 0) {
            return (this.page - 1) * this.pageSize;
        }
        if (this.list.size() == 0) {
            return -1;
        }
        return 0;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int value) {
        this.totalPages = value;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int value) {
        this.selectedIndex = value;
    }

    public int getSelectedMasterIndex() {
        if (this.pageMode) {
            return (this.page - 1) * this.pageSize + this.selectedIndex;
        }
        return this.selectedIndex;
    }

    public T getSelectedItem() {
        if (this.selectedIndex >= 0) {
            return this.list.get(this.selectedIndex);
        }
        return null;
    }

    public int getStartMasterIndex() {
        if (this.pageMode && this.list.size() > 0) {
            return (this.page - 1) * this.pageSize;
        }
        if (this.list.size() == 0) {
            return -1;
        }
        return 0;
    }
}

