/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeArgument;
import io.github.classgraph.TypeParameter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.matthewgreet.strutscommons.exception.ConverterNotDefaultException;
import name.matthewgreet.strutscommons.exception.CustomPolicyNotApplicableException;
import name.matthewgreet.strutscommons.exception.NotPolicyImplementationException;
import name.matthewgreet.strutscommons.exception.PolicyLookupRejectionException;
import name.matthewgreet.strutscommons.policy.AbstractAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractCollectionConverterSupport;
import name.matthewgreet.strutscommons.policy.AbstractCollectionPostConversionAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractCollectionPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.AbstractConverterSupport;
import name.matthewgreet.strutscommons.policy.AbstractNonConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.Adjuster;
import name.matthewgreet.strutscommons.policy.CollectionConverter;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionValidator;
import name.matthewgreet.strutscommons.policy.Converter;
import name.matthewgreet.strutscommons.policy.DefaultPolicy;
import name.matthewgreet.strutscommons.policy.NonConversionValidator;
import name.matthewgreet.strutscommons.policy.Policy;
import name.matthewgreet.strutscommons.policy.PostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.PostConversionValidator;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPolicyLookup
implements PolicyLookup {
    private static DefaultPolicyLookup instance;
    public static final String BASE_POLICY_PACKAGES = "name.matthewgreet.strutscommons.policy";
    private Logger LOG = LogManager.getLogger(DefaultPolicyLookup.class);
    private Collection<String> acceptClasses;
    private Collection<String> acceptPackages;
    private boolean classpathScanningReplaceBuiltIn;
    private boolean enableClasspathScanning;
    private Collection<String> rejectClasses;
    private Collection<String> rejectPackages;
    protected Map<Class<? extends Annotation>, InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> builtInPolicyMap;
    protected Map<Class<? extends Annotation>, InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> dynamicPolicyMap;
    protected Map<Class<?>, InterceptorCommonLibrary.DefaultConverterEntry<?, ?>> builtInDefaultConverterMap;
    protected Map<Class<?>, InterceptorCommonLibrary.DefaultConverterEntry<?, ?>> dynamicDefaultConverterMap;
    protected Map<Class<?>, InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?>> builtInDefaultCollectionConverterMap;
    protected Map<Class<?>, InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?>> dynamicDefaultCollectionConverterMap;
    protected Set<Class<?>> builtInPolicyClasses;
    protected Set<Class<?>> builtInDefaultConverterClasses;
    protected Set<Class<?>> builtInDefaultCollectionConverterClasses;

    public static synchronized void deleteInstance() {
        instance = null;
    }

    public static synchronized DefaultPolicyLookup getInstance() {
        if (instance == null) {
            instance = new DefaultPolicyLookup(new Configuration());
        }
        return instance;
    }

    public static synchronized DefaultPolicyLookup getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new DefaultPolicyLookup(configuration);
        }
        return instance;
    }

    public static <A extends Annotation, P extends Policy<A>, T> InterceptorCommonLibrary.PolicyEntry<?, ?, ?> makePolicyEntryFromClassNames(String annotationClassName, String policyClassName, String recipientTypeName, InterceptorCommonLibrary.AnnotationUsage annotationUsage, boolean builtIn, boolean defaultPolicy) throws ClassNotFoundException {
        Class<?> annotationClass = Class.forName(annotationClassName);
        Class<?> policyClass = Class.forName(policyClassName);
        Class<?> recipientTypeClass = recipientTypeName != null ? Class.forName(recipientTypeName) : null;
        return new InterceptorCommonLibrary.PolicyEntry(annotationClass, policyClass, recipientTypeClass, annotationUsage, builtIn, defaultPolicy);
    }

    protected DefaultPolicyLookup(Configuration configuration) {
        this.acceptClasses = configuration.getAcceptClasses() != null && configuration.getAcceptClasses().length() > 0 ? Collections.unmodifiableCollection(Arrays.asList(configuration.getAcceptClasses().split(","))) : Collections.emptyList();
        this.acceptPackages = configuration.getAcceptPackages() != null && configuration.getAcceptPackages().length() > 0 ? Collections.unmodifiableCollection(Arrays.asList(configuration.getAcceptPackages().split(","))) : Collections.emptyList();
        this.classpathScanningReplaceBuiltIn = configuration.getClasspathScanningReplaceBuiltIn();
        this.enableClasspathScanning = configuration.getEnableClasspathScanning();
        this.rejectClasses = configuration.getRejectClasses() != null && configuration.getRejectClasses().length() > 0 ? Collections.unmodifiableCollection(Arrays.asList(configuration.getRejectClasses().split(","))) : Collections.emptyList();
        this.rejectPackages = configuration.getRejectPackages() != null && configuration.getRejectPackages().length() > 0 ? Collections.unmodifiableCollection(Arrays.asList(configuration.getRejectPackages().split(","))) : Collections.emptyList();
        this.initBuiltInPolicyMap();
        this.initBuiltInDefaultConverterMap();
        this.initBuiltInDefaultCollectionConverterMap();
        if (this.enableClasspathScanning) {
            this.initDynamicPolicyMap();
            this.initDynamicDefaultConverterMap();
            this.initDynamicDefaultCollectionConverterMap();
        } else {
            this.dynamicPolicyMap = new HashMap();
            this.dynamicDefaultConverterMap = new HashMap();
            this.dynamicDefaultCollectionConverterMap = new HashMap();
        }
    }

    protected Class<?> actualTypeFromClassForInterface(Class<?> candidateClass, Class<?> interfaceClass, int genericTypeIndex) {
        String workingGenericName;
        boolean interfaceFound = false;
        Class result = null;
        ArrayList<GenericTypeDeclarationReflection> genericTypeDeclarations = new ArrayList<GenericTypeDeclarationReflection>();
        int workingTypeIndex = -1;
        Type genericType = null;
        block0: for (Class<?> workingClass = candidateClass; workingClass != null && !interfaceFound; workingClass = workingClass.getSuperclass()) {
            Type[] directInterfaceTypes;
            ParameterizedType workingSuperType = workingClass.getGenericSuperclass() instanceof ParameterizedType ? (ParameterizedType)workingClass.getGenericSuperclass() : null;
            GenericTypeDeclarationReflection genericTypeDeclaration = new GenericTypeDeclarationReflection();
            genericTypeDeclaration.setGenericsDeclaration(workingClass.getTypeParameters());
            genericTypeDeclaration.setSuperclassGenericsDeclaration(workingSuperType != null ? workingSuperType.getActualTypeArguments() : null);
            genericTypeDeclarations.add(genericTypeDeclaration);
            for (Type directInterfaceType : directInterfaceTypes = workingClass.getGenericInterfaces()) {
                if (!(directInterfaceType instanceof ParameterizedType) || !((ParameterizedType)directInterfaceType).getRawType().equals(interfaceClass)) continue;
                Type[] genericTypes = ((ParameterizedType)directInterfaceType).getActualTypeArguments();
                workingGenericName = genericTypes[genericTypeIndex].getTypeName();
                interfaceFound = true;
                for (int i = 0; i < genericTypes.length; ++i) {
                    genericType = genericTypes[i];
                    if (!workingGenericName.equals(genericType.getTypeName())) continue;
                    workingTypeIndex = genericTypeIndex;
                    break;
                }
                if (workingTypeIndex < 0) {
                    return (Class)genericType;
                }
                if (!interfaceFound) continue;
                genericTypeDeclaration.setSuperclassGenericsDeclaration(genericTypes);
                continue block0;
            }
        }
        if (interfaceFound && genericTypeDeclarations.size() > 0) {
            Type typeArgument;
            int declarationIndex;
            workingTypeIndex = genericTypeIndex;
            for (declarationIndex = genericTypeDeclarations.size() - 1; declarationIndex >= 0 && (typeArgument = ((GenericTypeDeclarationReflection)genericTypeDeclarations.get(declarationIndex)).getSuperclassGenericsDeclaration()[workingTypeIndex]) != null; --declarationIndex) {
                workingGenericName = typeArgument.getTypeName();
                int j = 0;
                boolean genericTypeFound = false;
                for (Type genericTypeDeclaration2 : ((GenericTypeDeclarationReflection)genericTypeDeclarations.get(declarationIndex)).getGenericsDeclaration()) {
                    if (genericTypeDeclaration2.getTypeName().equals(workingGenericName)) {
                        workingTypeIndex = j;
                        genericTypeFound = true;
                        break;
                    }
                    ++j;
                }
                if (!genericTypeFound) break;
            }
            if (declarationIndex >= 0) {
                result = (Class)((GenericTypeDeclarationReflection)genericTypeDeclarations.get(declarationIndex)).getSuperclassGenericsDeclaration()[workingTypeIndex];
            }
        }
        return result;
    }

    protected String actualTypeFromClassInfoForInterface(ClassInfo candidateClassInfo, Class<?> interfaceClass, int genericTypeIndex) {
        String workingGenericName;
        boolean interfaceFound = false;
        String result = null;
        ArrayList<GenericTypeDeclarationClassGraph> genericTypeDeclarations = new ArrayList<GenericTypeDeclarationClassGraph>();
        int workingTypeIndex = -1;
        block0: for (ClassInfo workingClassInfo = candidateClassInfo; workingClassInfo != null && !interfaceFound; workingClassInfo = workingClassInfo.getSuperclass()) {
            ClassRefTypeSignature workingSignature = workingClassInfo.getTypeSignature().getSuperclassSignature();
            GenericTypeDeclarationClassGraph genericTypeDeclaration = new GenericTypeDeclarationClassGraph();
            genericTypeDeclaration.setGenericsDeclaration(workingClassInfo.getTypeSignature().getTypeParameters());
            genericTypeDeclaration.setSuperclassGenericsDeclaration(workingSignature.getTypeArguments());
            genericTypeDeclarations.add(genericTypeDeclaration);
            ClassTypeSignature workingTypeSignature = workingClassInfo.getTypeSignature();
            List directInterfaceSignatures = workingTypeSignature.getSuperinterfaceSignatures();
            for (ClassRefTypeSignature directInterfaceSignature : directInterfaceSignatures) {
                if (!directInterfaceSignature.getBaseClassName().equals(interfaceClass.getName())) continue;
                List typeArguments = directInterfaceSignature.getTypeArguments();
                workingGenericName = ((TypeArgument)typeArguments.get(genericTypeIndex)).getTypeSignature().toString();
                interfaceFound = true;
                for (int i = 0; i < genericTypeDeclaration.getGenericsDeclaration().size(); ++i) {
                    TypeParameter typeParameter = genericTypeDeclaration.getGenericsDeclaration().get(i);
                    if (!workingGenericName.equals(typeParameter.getName())) continue;
                    workingTypeIndex = genericTypeIndex;
                    break;
                }
                if (workingTypeIndex < 0) {
                    return workingGenericName;
                }
                if (!interfaceFound) continue;
                genericTypeDeclaration.setSuperclassGenericsDeclaration(typeArguments);
                continue block0;
            }
        }
        if (interfaceFound && genericTypeDeclarations.size() > 0) {
            TypeArgument typeArgument;
            int declarationIndex;
            for (declarationIndex = genericTypeDeclarations.size() - 1; declarationIndex >= 0 && (typeArgument = ((GenericTypeDeclarationClassGraph)genericTypeDeclarations.get(declarationIndex)).getSuperclassGenericsDeclaration().get(workingTypeIndex)).getTypeSignature() != null; --declarationIndex) {
                workingGenericName = typeArgument.getTypeSignature().toString();
                int j = 0;
                boolean genericTypeFound = false;
                for (TypeParameter genericTypeDeclaration2 : ((GenericTypeDeclarationClassGraph)genericTypeDeclarations.get(declarationIndex)).getGenericsDeclaration()) {
                    if (genericTypeDeclaration2.getName().equals(workingGenericName)) {
                        workingTypeIndex = j;
                        genericTypeFound = true;
                        break;
                    }
                    ++j;
                }
                if (!genericTypeFound) break;
            }
            if (declarationIndex >= 0) {
                result = ((GenericTypeDeclarationClassGraph)genericTypeDeclarations.get(declarationIndex)).getSuperclassGenericsDeclaration().get(workingTypeIndex).toString();
            }
        }
        return result;
    }

    protected <A extends Annotation, P extends Policy<A>, T> void addDynamicPolicyInternalAutomatic(InterceptorCommonLibrary.PolicyEntry<A, P, T> policyEntry) {
        if (InterceptorCommonLibrary.isCustomAnnotationClass(policyEntry.getAnnotationClass())) {
            return;
        }
        InterceptorCommonLibrary.PolicyEntry<?, ?, ?> builtInPolicyEntry = this.builtInPolicyMap.get(policyEntry.getAnnotationClass());
        if (builtInPolicyEntry == null) {
            InterceptorCommonLibrary.PolicyEntry<?, ?, ?> existingPolicyEntry = this.dynamicPolicyMap.get(policyEntry.getAnnotationClass());
            if (existingPolicyEntry == null) {
                this.dynamicPolicyMap.put(policyEntry.getAnnotationClass(), policyEntry);
            } else if (policyEntry.getPolicyClass() != existingPolicyEntry.getPolicyClass()) {
                this.LOG.error("Classpath scanning found bespoke policies with clashing annotation  first policy class=" + policyEntry.getPolicyClass() + "  second policy class=" + existingPolicyEntry.getPolicyClass() + "  annotation=" + policyEntry.getAnnotationClass());
            }
        } else if (!this.builtInPolicyClasses.contains(policyEntry.getPolicyClass())) {
            this.LOG.error("Classpath scanning found bespoke policy using built-in annotation  policy class=" + policyEntry.getPolicyClass() + "  built-in annotation=" + policyEntry.getAnnotationClass());
        }
    }

    protected <A extends Annotation, P extends Policy<A>, T> InterceptorCommonLibrary.PolicyEntry<A, ?, ?> addDynamicPolicyInternalManual(InterceptorCommonLibrary.PolicyEntry<A, P, T> policyEntry) throws PolicyLookupRejectionException {
        if (InterceptorCommonLibrary.isCustomAnnotationClass(policyEntry.getAnnotationClass())) {
            String message = "Adding validation policy rejected as it's custom and doesn't need to be added  policy class=" + policyEntry.getPolicyClass() + "  built-in annotation=" + policyEntry.getAnnotationClass();
            this.LOG.error(message);
            throw new CustomPolicyNotApplicableException(policyEntry.getPolicyClass());
        }
        InterceptorCommonLibrary.PolicyEntry<Object, Object, Object> result = this.dynamicPolicyMap.put(policyEntry.getAnnotationClass(), policyEntry);
        if (result == null) {
            result = this.builtInPolicyMap.get(policyEntry.getAnnotationClass());
        }
        return result;
    }

    protected boolean defaultPolicyFromClass(Class<?> candidateClass) {
        return DefaultPolicy.class.isAssignableFrom(candidateClass);
    }

    protected boolean defaultPolicyFromClassInfo(ClassInfo candidateClassInfo) {
        return candidateClassInfo.implementsInterface(DefaultPolicy.class);
    }

    protected List<InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> getScannedPoliciesByType(ScanResult scanResult, Class<?> interfaceClass, Class<?> supportClass, InterceptorCommonLibrary.AnnotationUsage annotationUsage) {
        ClassInfo interfaceInfo = scanResult.getClassInfo(interfaceClass.getName());
        ClassInfoList candidateInfoList = interfaceInfo.getClassesImplementing();
        ArrayList<ClassInfo> candidateClassInfos = new ArrayList<ClassInfo>();
        ArrayList result = new ArrayList();
        for (ClassInfo candidateInfo : candidateInfoList) {
            if (candidateInfo.isAbstract()) continue;
            candidateClassInfos.add(candidateInfo);
        }
        for (ClassInfo candidateClassInfo : candidateClassInfos) {
            boolean recipientTypeNeeded;
            String recipientTypeName = null;
            boolean bl = recipientTypeNeeded = annotationUsage.getDirectInterfaceRecipientTypeIndex() != null;
            if (recipientTypeNeeded) {
                recipientTypeName = this.actualTypeFromClassInfoForInterface(candidateClassInfo, interfaceClass, annotationUsage.getDirectInterfaceRecipientTypeIndex());
            }
            boolean defaultPolicy = this.defaultPolicyFromClassInfo(candidateClassInfo);
            String annotationName = null;
            annotationName = this.actualTypeFromClassInfoForInterface(candidateClassInfo, interfaceClass, annotationUsage.getDirectInterfaceAnnotationIndex());
            if (!(annotationName == null || recipientTypeNeeded && recipientTypeName == null)) {
                try {
                    InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry = DefaultPolicyLookup.makePolicyEntryFromClassNames(annotationName, candidateClassInfo.getName(), recipientTypeName, annotationUsage, false, defaultPolicy);
                    result.add(policyEntry);
                }
                catch (ClassNotFoundException e) {
                    this.LOG.error("getScannedPoliciesByType: " + annotationName + " or " + candidateClassInfo.getName() + " found by class scanner but cannot be loaded");
                }
                continue;
            }
            String message = "Policy cannot be added as its recipient type cannot be found; it must directly implement " + annotationUsage.getDirectInterface() + " or inherit from " + annotationUsage.getSupportClass() + "  policy=" + candidateClassInfo;
            this.LOG.error(message);
        }
        return result;
    }

    protected void initBuiltInDefaultCollectionConverterMap() {
        if (this.builtInDefaultCollectionConverterMap == null) {
            HashMap working = new HashMap();
            HashSet converterClasses = new HashSet();
            List<InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?>> converterEntries = InterceptorCommonLibrary.getBuiltInDefaultCollectionConverters();
            for (InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?> converterEntry : converterEntries) {
                working.put(converterEntry.getItemClass(), converterEntry);
                converterClasses.add(converterEntry.getCollectionConverterClass());
            }
            this.builtInDefaultCollectionConverterMap = Collections.unmodifiableMap(working);
            this.builtInDefaultCollectionConverterClasses = Collections.unmodifiableSet(converterClasses);
        }
    }

    protected void initBuiltInDefaultConverterMap() {
        if (this.builtInDefaultConverterMap == null) {
            HashMap working = new HashMap();
            HashSet converterClasses = new HashSet();
            List<InterceptorCommonLibrary.DefaultConverterEntry<?, ?>> converterEntries = InterceptorCommonLibrary.getBuiltInDefaultConverters();
            for (InterceptorCommonLibrary.DefaultConverterEntry<?, ?> converterEntry : converterEntries) {
                working.put(converterEntry.getFieldClass(), converterEntry);
                converterClasses.add(converterEntry.getConverterClass());
            }
            this.builtInDefaultConverterMap = Collections.unmodifiableMap(working);
            this.builtInDefaultConverterClasses = Collections.unmodifiableSet(converterClasses);
        }
    }

    protected void initBuiltInPolicyMap() {
        if (this.builtInPolicyMap == null) {
            HashMap working = new HashMap();
            HashSet policyClasses = new HashSet();
            List<InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> policyEntries = InterceptorCommonLibrary.getBuiltInPolicies();
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                working.put(policyEntry.getAnnotationClass(), policyEntry);
                policyClasses.add(policyEntry.getPolicyClass());
            }
            this.builtInPolicyMap = Collections.unmodifiableMap(working);
            this.builtInPolicyClasses = Collections.unmodifiableSet(policyClasses);
        }
    }

    protected void initDynamicDefaultCollectionConverterMap() {
        this.dynamicDefaultCollectionConverterMap = new HashMap();
        for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : this.dynamicPolicyMap.values()) {
            if (policyEntry.getAnnotationUsage() != InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT || !policyEntry.getDefaultPolicy() || !this.classpathScanningReplaceBuiltIn && this.builtInDefaultCollectionConverterMap.containsKey(policyEntry.getRecipientType())) continue;
            InterceptorCommonLibrary.DefaultCollectionConverterEntry defaultCollectionConverterEntry = new InterceptorCommonLibrary.DefaultCollectionConverterEntry(policyEntry.getRecipientType(), policyEntry.getPolicyClass(), false);
            this.dynamicDefaultCollectionConverterMap.put(policyEntry.getRecipientType(), defaultCollectionConverterEntry);
        }
    }

    protected void initDynamicDefaultConverterMap() {
        this.dynamicDefaultConverterMap = new HashMap();
        for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : this.dynamicPolicyMap.values()) {
            if (policyEntry.getAnnotationUsage() != InterceptorCommonLibrary.AnnotationUsage.CONVERT || !policyEntry.getDefaultPolicy() || !this.classpathScanningReplaceBuiltIn && this.builtInDefaultConverterMap.containsKey(policyEntry.getRecipientType())) continue;
            InterceptorCommonLibrary.DefaultConverterEntry defaultConverterEntry = new InterceptorCommonLibrary.DefaultConverterEntry(policyEntry.getRecipientType(), policyEntry.getPolicyClass(), false);
            this.dynamicDefaultConverterMap.put(policyEntry.getRecipientType(), defaultConverterEntry);
        }
    }

    protected void initDynamicPolicyMap() {
        this.dynamicPolicyMap = new HashMap();
        ArrayList<String> workingAcceptPackages = new ArrayList<String>();
        if (this.acceptPackages.size() > 0 || this.acceptClasses.size() > 0) {
            workingAcceptPackages.add(BASE_POLICY_PACKAGES);
            workingAcceptPackages.addAll(this.acceptPackages);
        }
        ClassGraph classGraph = new ClassGraph();
        classGraph.enableClassInfo();
        classGraph.acceptClasses(this.acceptClasses.toArray(new String[0]));
        classGraph.acceptPackages(workingAcceptPackages.toArray(new String[0]));
        classGraph.rejectClasses(this.rejectClasses.toArray(new String[0]));
        classGraph.rejectPackages(this.rejectPackages.toArray(new String[0]));
        try (ScanResult scanResult = classGraph.scan();){
            List<InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> policyEntries = this.getScannedPoliciesByType(scanResult, Adjuster.class, AbstractAdjusterSupport.class, InterceptorCommonLibrary.AnnotationUsage.ADJUSTER);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, CollectionConverter.class, AbstractCollectionConverterSupport.class, InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, CollectionPostConversionAdjuster.class, AbstractCollectionPostConversionAdjusterSupport.class, InterceptorCommonLibrary.AnnotationUsage.COLLECTION_POST_ADJUSTER);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, CollectionPostConversionValidator.class, AbstractCollectionPostConversionValidatorSupport.class, InterceptorCommonLibrary.AnnotationUsage.COLLECTION_POST_VALIDATION);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, Converter.class, AbstractConverterSupport.class, InterceptorCommonLibrary.AnnotationUsage.CONVERT);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, NonConversionValidator.class, AbstractNonConversionValidatorSupport.class, InterceptorCommonLibrary.AnnotationUsage.NON_CONVERT_VALIDATION);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, PostConversionAdjuster.class, AbstractPostConversionAdjusterSupport.class, InterceptorCommonLibrary.AnnotationUsage.POST_ADJUSTER);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
            policyEntries = this.getScannedPoliciesByType(scanResult, PostConversionValidator.class, AbstractPostConversionValidatorSupport.class, InterceptorCommonLibrary.AnnotationUsage.POST_VALIDATION);
            for (InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry : policyEntries) {
                this.addDynamicPolicyInternalAutomatic(policyEntry);
            }
        }
    }

    protected Class<?> translateDefaultConverterRecipientClass(Class<?> recipientClass) {
        if (Enum.class.isAssignableFrom(recipientClass)) {
            return Enum.class;
        }
        return InterceptorCommonLibrary.getConverterClassLookupFromFormFieldClass(recipientClass);
    }

    public Collection<String> getAcceptClasses() {
        return this.acceptClasses;
    }

    public Collection<String> getAcceptPackages() {
        return this.acceptPackages;
    }

    public boolean getClasspathScanningReplaceBuiltIn() {
        return this.classpathScanningReplaceBuiltIn;
    }

    @Override
    public Collection<InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?>> getDefaultCollectionConverterEntries() {
        Set<Class<?>> dynamicClassesInUse = this.dynamicDefaultCollectionConverterMap.keySet();
        ArrayList result = new ArrayList();
        result.addAll(this.dynamicDefaultCollectionConverterMap.values());
        for (InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?> builtInEntry : this.builtInDefaultCollectionConverterMap.values()) {
            if (dynamicClassesInUse.contains(builtInEntry.getItemClass())) continue;
            result.add(builtInEntry);
        }
        return result;
    }

    @Override
    public <C extends CollectionConverter<?, T>, T> InterceptorCommonLibrary.DefaultCollectionConverterEntry<T, C> getDefaultCollectionConverterEntry(Class<? extends T> itemClass) {
        Class<?> workingItemClass = this.translateDefaultConverterRecipientClass(itemClass);
        InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?> result = this.dynamicDefaultCollectionConverterMap.get(workingItemClass);
        if (result == null) {
            result = this.builtInDefaultCollectionConverterMap.get(workingItemClass);
        }
        return result;
    }

    @Override
    public Collection<InterceptorCommonLibrary.DefaultConverterEntry<?, ?>> getDefaultConverterEntries() {
        Set<Class<?>> dynamicClassesInUse = this.dynamicDefaultConverterMap.keySet();
        ArrayList result = new ArrayList();
        result.addAll(this.dynamicDefaultConverterMap.values());
        for (InterceptorCommonLibrary.DefaultConverterEntry<?, ?> builtInEntry : this.builtInDefaultConverterMap.values()) {
            if (dynamicClassesInUse.contains(builtInEntry.getFieldClass())) continue;
            result.add(builtInEntry);
        }
        return result;
    }

    @Override
    public <C extends Converter<?, T>, T> InterceptorCommonLibrary.DefaultConverterEntry<T, C> getDefaultConverterEntry(Class<? extends T> fieldClass) {
        Class<?> workingFieldClass = this.translateDefaultConverterRecipientClass(fieldClass);
        InterceptorCommonLibrary.DefaultConverterEntry<?, ?> result = this.dynamicDefaultConverterMap.get(workingFieldClass);
        if (result == null) {
            result = this.builtInDefaultConverterMap.get(workingFieldClass);
        }
        return result;
    }

    public boolean getEnableClasspathScanning() {
        return this.enableClasspathScanning;
    }

    @Override
    public Collection<InterceptorCommonLibrary.PolicyEntry<?, ?, ?>> getPolicyEntries() {
        ArrayList result = new ArrayList();
        result.addAll(this.builtInPolicyMap.values());
        result.addAll(this.dynamicPolicyMap.values());
        return result;
    }

    @Override
    public <A extends Annotation, P extends Policy<A>, T> InterceptorCommonLibrary.PolicyEntry<A, P, T> getPolicyEntry(Class<? extends A> annotationClass) {
        InterceptorCommonLibrary.PolicyEntry<?, ?, ?> result = this.dynamicPolicyMap.get(annotationClass);
        if (result == null) {
            result = this.builtInPolicyMap.get(annotationClass);
        }
        return result;
    }

    public Collection<String> getRejectClasses() {
        return this.rejectClasses;
    }

    public Collection<String> getRejectPackages() {
        return this.rejectPackages;
    }

    @Override
    public <C extends CollectionConverter<?, T>, T> InterceptorCommonLibrary.DefaultCollectionConverterEntry<T, ?> putDefaultCollectionConverter(Class<C> collectionConverterClass) throws PolicyLookupRejectionException {
        if (collectionConverterClass.isInterface() || Modifier.isAbstract(collectionConverterClass.getModifiers())) {
            throw new NotPolicyImplementationException(collectionConverterClass);
        }
        Class<?> annotationClass = null;
        annotationClass = this.actualTypeFromClassForInterface(collectionConverterClass, InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT.getDirectInterface(), InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterfaceAnnotationIndex());
        if (InterceptorCommonLibrary.isCustomAnnotationClass(annotationClass)) {
            throw new CustomPolicyNotApplicableException(collectionConverterClass);
        }
        if (!DefaultPolicy.class.isAssignableFrom(collectionConverterClass)) {
            throw new ConverterNotDefaultException(collectionConverterClass);
        }
        Class<?> recipientItemType = null;
        recipientItemType = this.actualTypeFromClassForInterface(collectionConverterClass, InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT.getDirectInterface(), InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT.getDirectInterfaceRecipientTypeIndex());
        if (recipientItemType != null) {
            InterceptorCommonLibrary.DefaultCollectionConverterEntry defaultCollectionConverterEntry = new InterceptorCommonLibrary.DefaultCollectionConverterEntry(recipientItemType, collectionConverterClass, false);
            InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, Object> result = this.dynamicDefaultCollectionConverterMap.put(recipientItemType, defaultCollectionConverterEntry);
            if (result == null) {
                result = this.builtInDefaultCollectionConverterMap.get(recipientItemType);
            }
            return result;
        }
        String message = "Collection converter class cannot be added as default collection converter as it does not directly implement " + InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT.getDirectInterface() + " nor inherit from " + InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT.getSupportClass();
        this.LOG.error(message);
        throw new PolicyLookupRejectionException(message, collectionConverterClass);
    }

    @Override
    public <C extends Converter<?, T>, T> InterceptorCommonLibrary.DefaultConverterEntry<T, ?> putDefaultConverter(Class<C> converterClass) throws PolicyLookupRejectionException {
        if (converterClass.isInterface() || Modifier.isAbstract(converterClass.getModifiers())) {
            throw new NotPolicyImplementationException(converterClass);
        }
        Class<?> annotationClass = null;
        annotationClass = this.actualTypeFromClassForInterface(converterClass, InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterface(), InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterfaceAnnotationIndex());
        if (InterceptorCommonLibrary.isCustomAnnotationClass(annotationClass)) {
            throw new CustomPolicyNotApplicableException(converterClass);
        }
        if (!DefaultPolicy.class.isAssignableFrom(converterClass)) {
            throw new ConverterNotDefaultException(converterClass);
        }
        Class<?> recipientType = null;
        recipientType = this.actualTypeFromClassForInterface(converterClass, InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterface(), InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterfaceRecipientTypeIndex());
        if (recipientType != null) {
            InterceptorCommonLibrary.DefaultConverterEntry defaultConverterEntry = new InterceptorCommonLibrary.DefaultConverterEntry(recipientType, converterClass, false);
            InterceptorCommonLibrary.DefaultConverterEntry<?, Object> result = this.dynamicDefaultConverterMap.put(recipientType, defaultConverterEntry);
            if (result == null) {
                result = this.builtInDefaultConverterMap.get(recipientType);
            }
            return result;
        }
        String message = "Converter class cannot be added as default converter as it does not directly implement " + InterceptorCommonLibrary.AnnotationUsage.CONVERT.getDirectInterface() + " nor inherit from " + InterceptorCommonLibrary.AnnotationUsage.CONVERT.getSupportClass();
        this.LOG.error(message);
        throw new PolicyLookupRejectionException(message, converterClass);
    }

    @Override
    public <A extends Annotation, P extends Policy<A>, T> InterceptorCommonLibrary.PolicyEntry<A, ?, ?> putPolicy(Class<P> policyClass) throws PolicyLookupRejectionException {
        if (policyClass.isInterface() || Modifier.isAbstract(policyClass.getModifiers())) {
            throw new NotPolicyImplementationException(policyClass);
        }
        InterceptorCommonLibrary.PolicyEntry<?, ?, ?> result = null;
        InterceptorCommonLibrary.AnnotationUsage annotationUsage = InterceptorCommonLibrary.getAnnotationUsageFromPolicyClass(policyClass);
        Class<?> directInterfaceClass = annotationUsage.getDirectInterface();
        if (directInterfaceClass != null) {
            Class<?> annotationClass = null;
            annotationClass = this.actualTypeFromClassForInterface(policyClass, directInterfaceClass, annotationUsage.getDirectInterfaceAnnotationIndex());
            if (annotationClass != null && InterceptorCommonLibrary.isCustomAnnotationClass(annotationClass)) {
                throw new CustomPolicyNotApplicableException(policyClass);
            }
            boolean defaultPolicy = this.defaultPolicyFromClass(policyClass);
            Class<?> recipientType = null;
            if (annotationUsage.getDirectInterfaceRecipientTypeIndex() != null) {
                recipientType = this.actualTypeFromClassForInterface(policyClass, directInterfaceClass, annotationUsage.getDirectInterfaceRecipientTypeIndex());
            }
            if (annotationClass != null) {
                InterceptorCommonLibrary.PolicyEntry policyEntry = new InterceptorCommonLibrary.PolicyEntry(annotationClass, policyClass, recipientType, annotationUsage, false, defaultPolicy);
                result = this.addDynamicPolicyInternalManual(policyEntry);
            }
        } else {
            throw new NotPolicyImplementationException(policyClass);
        }
        return result;
    }

    @Override
    public <C extends CollectionConverter<?, T>, T> InterceptorCommonLibrary.DefaultCollectionConverterEntry<T, C> removeDefaultCollectionConverter(Class<? extends T> itemClass) throws IllegalArgumentException {
        InterceptorCommonLibrary.DefaultCollectionConverterEntry<?, ?> defaultCollectionConverterEntry = this.builtInDefaultCollectionConverterMap.get(itemClass);
        if (defaultCollectionConverterEntry != null) {
            String message = "Built-in converters cannot be removed as default converters  itemClass=" + itemClass;
            this.LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        defaultCollectionConverterEntry = this.dynamicDefaultCollectionConverterMap.remove(itemClass);
        return defaultCollectionConverterEntry;
    }

    @Override
    public <C extends Converter<?, T>, T> InterceptorCommonLibrary.DefaultConverterEntry<T, C> removeDefaultConverter(Class<? extends T> fieldClass) throws IllegalArgumentException {
        InterceptorCommonLibrary.DefaultConverterEntry<?, ?> defaultConverterEntry = this.builtInDefaultConverterMap.get(fieldClass);
        if (defaultConverterEntry != null) {
            String message = "Built-in converters cannot be removed as default converters  fieldClass=" + fieldClass;
            this.LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        defaultConverterEntry = this.dynamicDefaultConverterMap.remove(fieldClass);
        return defaultConverterEntry;
    }

    @Override
    public <A extends Annotation, P extends Policy<A>, T> InterceptorCommonLibrary.PolicyEntry<A, P, T> removePolicy(Class<? extends A> annotationClass) throws IllegalArgumentException {
        InterceptorCommonLibrary.PolicyEntry<?, ?, ?> policyEntry = this.builtInPolicyMap.get(annotationClass);
        if (policyEntry != null) {
            String message = "Built-in policies cannot be removed  annotation=" + annotationClass;
            this.LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        policyEntry = this.dynamicPolicyMap.remove(annotationClass);
        return policyEntry;
    }

    public static class Configuration
    implements Serializable {
        private static final long serialVersionUID = 7574407573480814754L;
        private String acceptClasses = "";
        private String acceptPackages = "";
        private boolean classpathScanningReplaceBuiltIn = false;
        private boolean enableClasspathScanning = false;
        private String rejectClasses = "";
        private String rejectPackages = "";

        public String getAcceptClasses() {
            return this.acceptClasses;
        }

        public void setAcceptClasses(String acceptClasses) {
            this.acceptClasses = acceptClasses;
        }

        public String getAcceptPackages() {
            return this.acceptPackages;
        }

        public void setAcceptPackages(String acceptPackages) {
            this.acceptPackages = acceptPackages;
        }

        public boolean getClasspathScanningReplaceBuiltIn() {
            return this.classpathScanningReplaceBuiltIn;
        }

        public void setClasspathScanningReplaceBuiltIn(boolean classpathScanningReplaceBuiltIn) {
            this.classpathScanningReplaceBuiltIn = classpathScanningReplaceBuiltIn;
        }

        public boolean getEnableClasspathScanning() {
            return this.enableClasspathScanning;
        }

        public void setEnableClasspathScanning(boolean enableClasspathScanning) {
            this.enableClasspathScanning = enableClasspathScanning;
        }

        public String getRejectClasses() {
            return this.rejectClasses;
        }

        public void setRejectClasses(String rejectClasses) {
            this.rejectClasses = rejectClasses;
        }

        public String getRejectPackages() {
            return this.rejectPackages;
        }

        public void setRejectPackages(String rejectPackages) {
            this.rejectPackages = rejectPackages;
        }
    }

    public static class GenericTypeDeclarationReflection {
        private Type[] genericsDeclaration;
        private Type[] superclassGenericsDeclaration;

        public Type[] getGenericsDeclaration() {
            return this.genericsDeclaration;
        }

        public void setGenericsDeclaration(Type[] types) {
            this.genericsDeclaration = types;
        }

        public Type[] getSuperclassGenericsDeclaration() {
            return this.superclassGenericsDeclaration;
        }

        public void setSuperclassGenericsDeclaration(Type[] types) {
            this.superclassGenericsDeclaration = types;
        }

        public String toString() {
            return "GenericTypeDeclarationReflection [genericsDeclaration=" + this.genericsDeclaration + ", superclassGenericsDeclaration=" + this.superclassGenericsDeclaration + "]";
        }
    }

    public static class GenericTypeDeclarationClassGraph {
        private List<TypeParameter> genericsDeclaration;
        private List<TypeArgument> superclassGenericsDeclaration;

        public List<TypeParameter> getGenericsDeclaration() {
            return this.genericsDeclaration;
        }

        public void setGenericsDeclaration(List<TypeParameter> genericsDeclaration) {
            this.genericsDeclaration = genericsDeclaration;
        }

        public List<TypeArgument> getSuperclassGenericsDeclaration() {
            return this.superclassGenericsDeclaration;
        }

        public void setSuperclassGenericsDeclaration(List<TypeArgument> superclassGenericsDeclaration) {
            this.superclassGenericsDeclaration = superclassGenericsDeclaration;
        }

        public String toString() {
            return "GenericTypeDeclarationClassGraph [genericsDeclaration=" + this.genericsDeclaration + ", superclassGenericsDeclaration=" + this.superclassGenericsDeclaration + "]";
        }
    }
}

