/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.util.ValueStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.annotation.Form;
import name.matthewgreet.strutscommons.form.FormatResult;
import name.matthewgreet.strutscommons.form.FormattableForm;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.FormFormatter;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultFormFormatter
implements FormFormatter {
    private Logger LOG = LogManager.getLogger(DefaultFormFormatter.class);

    protected InterceptorCommonLibrary.CategoriseFieldResult categoriseFields(Collection<Field> formFields, Object action, Object form) {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        InterceptorCommonLibrary.CategoriseFieldResult result = InterceptorCommonLibrary.categoriseFormFields(formFields, interceptorContext.getPolicyLookup(), false);
        interceptorContext.setAutoParameterConversionFields(result.getAutoParameterConversionFields());
        interceptorContext.setDefaultParameterConversionFields(result.getDefaultParameterConversionFields());
        interceptorContext.setManualParameterConversionFields(result.getManualParameterConversionFields());
        interceptorContext.setNoConversionFields(result.getNoConversionFields());
        interceptorContext.setPairConversionFields(result.getPairConversionFields());
        interceptorContext.setSetOnlyFields(result.getSetOnlyFields());
        return result;
    }

    protected <T> void endFieldContext() {
        FieldContext fieldContext = FieldContext.getInstance();
        fieldContext.setStep(FieldContext.FieldStep.END);
    }

    protected void endFormProcessing() {
    }

    protected void endInterceptorContext() {
    }

    protected boolean fieldIsForm(Field actionField) {
        Class<?> fieldClass = actionField.getType();
        return FormattableForm.class.isAssignableFrom(fieldClass);
    }

    protected boolean fieldReceivedStoredForm(Field actionField) {
        return InterceptorCommonLibrary.fieldReceivedStoredForm(actionField);
    }

    protected Collection<Field> filterFormFields(Collection<Field> allFormFields, Map<String, ConversionData> conversionErrors) {
        Collection<Field> working = allFormFields;
        working = InterceptorCommonLibrary.filterNonConversionErrorFormFields(working, conversionErrors);
        working = InterceptorCommonLibrary.filterPlausibleFormFields(working);
        return working;
    }

    protected void formatForm() {
        FieldContext fieldContext;
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        Object action = interceptorContext.getAction();
        Object form = interceptorContext.getForm();
        if (form == null) {
            return;
        }
        if (!(form instanceof FormattableForm)) {
            return;
        }
        interceptorContext.setStep(InterceptorContext.InterceptorStep.ANNOTATION_PARSING);
        Collection<Field> allFormFields = this.getProperties(form.getClass());
        allFormFields = interceptorContext.getSkipConversionErrors() ? this.filterFormFields(allFormFields, ActionContext.getContext().getConversionErrors()) : this.filterFormFields(allFormFields, null);
        InterceptorCommonLibrary.CategoriseFieldResult categoriseFieldResult = this.categoriseFields(allFormFields, action, form);
        interceptorContext.setStep(InterceptorContext.InterceptorStep.FIELD_PROCESSING);
        for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : categoriseFieldResult.getAutoParameterConversionFields()) {
            try {
                fieldContext = this.makeFieldContext();
                FieldContext.setInstance(fieldContext);
                this.startFieldContext(FieldContext.FormatMode.AUTO, fieldUsage, null);
                this.processAutoField();
                this.endFieldContext();
            }
            catch (Exception e) {
                this.LOG.error("Formatting auto conversion field failed  Struts action=" + action.getClass() + "  form=" + form.getClass() + "  unformatted field=" + fieldUsage.getName(), (Throwable)e);
            }
        }
        for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : categoriseFieldResult.getDefaultParameterConversionFields()) {
            try {
                fieldContext = this.makeFieldContext();
                FieldContext.setInstance(fieldContext);
                this.startFieldContext(FieldContext.FormatMode.DEFAULT, fieldUsage, null);
                this.processAutoField();
                this.endFieldContext();
            }
            catch (Exception e) {
                this.LOG.error("Formatting default conversion field failed  Struts action=" + action.getClass() + "  form=" + form.getClass() + "  unformatted field=" + fieldUsage.getName(), (Throwable)e);
            }
        }
        for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : categoriseFieldResult.getNoConversionFields()) {
            try {
                fieldContext = this.makeFieldContext();
                FieldContext.setInstance(fieldContext);
                this.startFieldContext(FieldContext.FormatMode.NONE, fieldUsage, null);
                this.processNoConversionField();
                this.endFieldContext();
            }
            catch (Exception e) {
                this.LOG.error("Formatting no conversion field failed  Struts action=" + action.getClass() + "  form=" + form.getClass() + "  unformatted field=" + fieldUsage.getName(), (Throwable)e);
            }
        }
        for (InterceptorCommonLibrary.PairFieldUsage pairFieldUsage : categoriseFieldResult.getPairConversionFields()) {
            try {
                fieldContext = this.makeFieldContext();
                FieldContext.setInstance(fieldContext);
                this.startFieldContext(FieldContext.FormatMode.PAIR, null, pairFieldUsage);
                this.processPairField();
                this.endFieldContext();
            }
            catch (Exception e) {
                this.LOG.error("Formatting pair conversion field failed  Struts action=" + action.getClass() + "  form=" + form.getClass() + "  formatted field=" + pairFieldUsage.getFormattedName() + "  unformatted field=" + pairFieldUsage.getUnformattedName(), (Throwable)e);
            }
        }
        for (InterceptorCommonLibrary.FieldUsage fieldUsage : categoriseFieldResult.getSetOnlyFields()) {
            try {
                fieldContext = this.makeFieldContext();
                FieldContext.setInstance(fieldContext);
                this.startFieldContext(FieldContext.FormatMode.SET_ONLY, fieldUsage, null);
                this.processSetOnlyField();
                this.endFieldContext();
            }
            catch (Exception e) {
                this.LOG.error("Formatting default conversion field failed  Struts action=" + action.getClass() + "  form=" + form.getClass() + "  unformatted field=" + fieldUsage.getName(), (Throwable)e);
            }
        }
        interceptorContext.setStep(InterceptorContext.InterceptorStep.MANUAL_FORMATTING);
        try {
            this.processManualParameterField();
        }
        catch (Exception e) {
            this.LOG.error("Formatting manual parameters failed  Struts action=" + action.getClass() + "  form=" + form.getClass(), (Throwable)e);
        }
    }

    protected Collection<Field> getProperties(Class<?> type) {
        return InterceptorCommonLibrary.getProperties(type);
    }

    protected <T> FieldContext<T> makeFieldContext() {
        return new FieldContext();
    }

    protected InterceptorContext makeInterceptorContext() {
        return new InterceptorContext();
    }

    protected <T> void processAutoField() {
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.FieldUsage fieldUsage = fieldContext.getFieldUsage();
        if (fieldUsage.getCollection()) {
            String formattedValue = this.processCollectionConverter();
            fieldContext.setFormattedValue(formattedValue);
            fieldContext.setFormattedMultipleValues(null);
            this.putFakeFormField();
        } else {
            String formattedValue = this.processConverter();
            fieldContext.setFormattedValue(formattedValue);
            fieldContext.setFormattedMultipleValues(null);
            this.putFakeFormField();
        }
    }

    protected <T> String processCollectionConverter() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        Collection unformattedValue = null;
        try {
            unformattedValue = fieldContext.getUnformattedCollectionValue();
            String result = unformattedValue != null && unformattedValue.size() > 0 ? fieldContext.getAnnountationEntries().getCollectionConverter().getCollectionConverter().format(unformattedValue) : "";
            return result;
        }
        catch (IllegalArgumentException e) {
            this.LOG.error("Security violation when accessing form  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName(), (Throwable)e);
        }
        catch (ClassCastException e) {
            this.LOG.error("Form field type doesn't match converter  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName(), (Throwable)e);
        }
        catch (Exception e) {
            this.LOG.error("Converter failed  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName() + "  value=" + unformattedValue, (Throwable)e);
        }
        return null;
    }

    protected <T> String processConverter() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        Object unformattedValue = null;
        try {
            unformattedValue = fieldContext.getUnformattedValue();
            String result = unformattedValue != null ? fieldContext.getAnnountationEntries().getConverter().getConverter().format(unformattedValue) : "";
            return result;
        }
        catch (IllegalArgumentException e) {
            this.LOG.error("Security violation when accessing form  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName(), (Throwable)e);
        }
        catch (ClassCastException e) {
            this.LOG.error("Form field type doesn't match converter  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName(), (Throwable)e);
        }
        catch (Exception e) {
            this.LOG.error("Converter failed  Struts action=" + interceptorContext.getAction().getClass() + "  field=" + fieldContext.getFieldName() + "  value=" + unformattedValue, (Throwable)e);
        }
        return null;
    }

    protected <T> void processDefaultField() {
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.FieldUsage fieldUsage = fieldContext.getFieldUsage();
        if (fieldUsage.getCollection()) {
            String formattedValue = this.processCollectionConverter();
            fieldContext.setFormattedValue(formattedValue);
            fieldContext.setFormattedMultipleValues(null);
            this.putFakeFormField();
        } else {
            String formattedValue = this.processConverter();
            fieldContext.setFormattedValue(formattedValue);
            fieldContext.setFormattedMultipleValues(null);
            this.putFakeFormField();
        }
    }

    protected void processFormattedValues() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        Map<String, Map<String, Object>> fakeForms = interceptorContext.getFakeForms();
        InterceptorCommonLibrary.getActionContextFormattedForms().putAll(fakeForms);
        ValueStack valueStack = interceptorContext.getInvocation().getStack();
        valueStack.push(fakeForms);
    }

    protected <T> void processManualParameterField() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        FormattableForm formattableForm = interceptorContext.getFormattableForm();
        if (formattableForm != null) {
            FormatResult formatResult = formattableForm.format();
            for (Map.Entry<String, String> entry : formatResult.getFormattedSingleFieldValues().entrySet()) {
                fieldContext.setUnformattedField(null);
                fieldContext.setFieldName(entry.getKey());
                fieldContext.setFormattedValue(entry.getValue());
                fieldContext.setFormattedMultipleValues(null);
                this.putFakeFormField();
            }
            for (Map.Entry<String, Object> entry : formatResult.getFormattedMultipleFieldValues().entrySet()) {
                ArrayList<String> fieldValues = new ArrayList<String>();
                for (String fieldValue : (List)entry.getValue()) {
                    fieldValues.add(fieldValue);
                }
                fieldContext.setUnformattedField(null);
                fieldContext.setFieldName(entry.getKey());
                fieldContext.setFormattedValue(null);
                fieldContext.setFormattedMultipleValues(fieldValues);
                this.putFakeMultipleFormField();
            }
        }
    }

    protected void processNoConversionField() {
        FieldContext fieldContext = FieldContext.getInstance();
        String unformattedValue = (String)fieldContext.getUnformattedValue();
        String formattedValue = unformattedValue != null ? unformattedValue : "";
        fieldContext.setFormattedValue(formattedValue);
        fieldContext.setFormattedMultipleValues(null);
        this.putFakeFormField();
    }

    protected void processSetOnlyField() {
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.FieldUsage fieldUsage = fieldContext.getFieldUsage();
        if (fieldUsage.getArray()) {
            List formattedCollectionValue = (List)fieldContext.getUnformattedCollectionValue();
            fieldContext.setFormattedValue(null);
            fieldContext.setFormattedMultipleValues(formattedCollectionValue);
            this.putFakeMultipleFormField();
        } else if (fieldUsage.getCollection()) {
            List formattedCollectionValue = (List)fieldContext.getUnformattedCollectionValue();
            fieldContext.setFormattedValue(null);
            fieldContext.setFormattedMultipleValues(formattedCollectionValue);
            this.putFakeMultipleFormField();
        } else {
            String formattedValue = (String)fieldContext.getUnformattedValue();
            fieldContext.setFormattedValue(formattedValue);
            fieldContext.setFormattedMultipleValues(null);
            this.putFakeFormField();
        }
    }

    protected <T> void putFakeMultipleFormField() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formName = interceptorContext.getActionField().getName();
        String fieldName = fieldContext.getFieldName();
        Map<String, Object> fakeForm = interceptorContext.getFakeForms().get(formName);
        if (fakeForm == null) {
            fakeForm = new HashMap<String, Object>();
            interceptorContext.getFakeForms().put(formName, fakeForm);
        }
        fakeForm.put(fieldName, fieldContext.getFormattedMultipleValues());
    }

    protected <T> void putFakeFormField() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formName = interceptorContext.getActionField().getName();
        String fieldName = fieldContext.getFieldName();
        Map<String, Object> fakeForm = interceptorContext.getFakeForms().get(formName);
        if (fakeForm == null) {
            fakeForm = new HashMap<String, Object>();
            interceptorContext.getFakeForms().put(formName, fakeForm);
        }
        fakeForm.put(fieldName, fieldContext.getFormattedValue());
    }

    protected <T> void processPairField() throws Exception {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        FormattableForm form = interceptorContext.getFormattableForm();
        InterceptorCommonLibrary.PairFieldUsage pairFieldUsage = fieldContext.getPairFieldUsage();
        String formattedValue = this.processConverter();
        fieldContext.setFormattedValue(formattedValue);
        fieldContext.setFormattedMultipleValues(null);
        pairFieldUsage.getFormattedField().setAccessible(true);
        pairFieldUsage.getFormattedField().set(form, formattedValue);
        this.putFakeFormField();
    }

    protected <T> void startFieldContext(FieldContext.FormatMode formatType, InterceptorCommonLibrary.FieldUsage<T> fieldUsage, InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage) throws Exception {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext<Object> fieldContext = FieldContext.getInstance();
        fieldContext.setStep(FieldContext.FieldStep.START);
        fieldContext.setFormatType(formatType);
        fieldContext.setFieldUsage(fieldUsage);
        fieldContext.setPairFieldUsage(pairFieldUsage);
        switch (formatType.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                fieldContext.setUnformattedField(fieldUsage.getField());
                fieldContext.setAnnountationEntries(fieldUsage.getAnnountationEntries());
                fieldContext.setFieldName(fieldUsage.getName());
                fieldUsage.getField().setAccessible(true);
                if (fieldUsage.getArray()) {
                    Object[] unformattedArrayValues = (Object[])fieldContext.getUnformattedField().get(interceptorContext.getForm());
                    fieldContext.setUnformattedValue(null);
                    fieldContext.setUnformattedCollectionValue(Arrays.asList(unformattedArrayValues));
                    break;
                }
                if (fieldUsage.getCollection()) {
                    Collection unformattedCollectionValues = (Collection)fieldContext.getUnformattedField().get(interceptorContext.getForm());
                    fieldContext.setUnformattedValue(null);
                    fieldContext.setUnformattedCollectionValue(unformattedCollectionValues);
                    break;
                }
                Object unformattedValue = fieldContext.getUnformattedField().get(interceptorContext.getForm());
                fieldContext.setUnformattedValue(unformattedValue);
                fieldContext.setUnformattedCollectionValue(null);
                break;
            }
            case 3: {
                fieldContext.setUnformattedField(pairFieldUsage.getUnformattedField());
                fieldContext.setAnnountationEntries(pairFieldUsage.getAnnountationEntries());
                fieldContext.setFieldName(pairFieldUsage.getFormattedName());
                pairFieldUsage.getUnformattedField().setAccessible(true);
                pairFieldUsage.getFormattedField().setAccessible(true);
                Object unformattedValue = fieldContext.getUnformattedField().get(interceptorContext.getForm());
                fieldContext.setUnformattedValue(unformattedValue);
                fieldContext.setUnformattedCollectionValue(null);
            }
        }
    }

    protected void startFormProcessing(Field actionField, boolean skipConversionErrors) throws Exception {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        interceptorContext.setActionField(actionField);
        Object action = interceptorContext.getAction();
        Object form = actionField.get(action);
        interceptorContext.setForm(form);
        if (form instanceof FormattableForm) {
            FormattableForm formattableForm = (FormattableForm)form;
            interceptorContext.setFormattableForm(formattableForm);
        }
        interceptorContext.setSkipConversionErrors(skipConversionErrors);
    }

    protected void startInterceptorContext(ActionInvocation invocation, PolicyLookup policyLookup) {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        interceptorContext.setInvocation(invocation);
        Object action = invocation.getAction();
        interceptorContext.setAction(action);
        interceptorContext.setFakeForms(new HashMap<String, Map<String, Object>>());
        interceptorContext.setPolicyLookup(policyLookup);
    }

    @Override
    public void formatForms() {
        this.formatForms(DefaultPolicyLookup.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatForms(PolicyLookup policyLookup) {
        InterceptorContext interceptorContext = this.makeInterceptorContext();
        try {
            InterceptorContext.setInstance(interceptorContext);
            interceptorContext.setStep(InterceptorContext.InterceptorStep.START);
            this.startInterceptorContext(ActionContext.getContext().getActionInvocation(), policyLookup);
            Object action = ActionContext.getContext().getActionInvocation().getAction();
            Collection<Field> actionFields = this.getProperties(action.getClass());
            for (Field actionField : actionFields) {
                boolean skipConversionErrors = this.fieldReceivedStoredForm(actionField);
                boolean doForm = this.fieldIsForm(actionField);
                if (!doForm) continue;
                try {
                    actionField.setAccessible(true);
                    Form formAnnotation = actionField.getAnnotation(Form.class);
                    if (formAnnotation != null && formAnnotation.disableFormatting()) continue;
                    interceptorContext.setStep(InterceptorContext.InterceptorStep.FORM_PROCESSING_START);
                    this.startFormProcessing(actionField, skipConversionErrors);
                    this.formatForm();
                    interceptorContext.setStep(InterceptorContext.InterceptorStep.FORM_PROCESSING_END);
                    this.endFormProcessing();
                }
                catch (Exception e) {
                    this.LOG.error("Security violation when accessing form  Struts action=" + action.getClass() + "  field=" + actionField.getName(), (Throwable)e);
                }
            }
            interceptorContext.setStep(InterceptorContext.InterceptorStep.FORMAT_WRITING);
            this.processFormattedValues();
        }
        finally {
            interceptorContext.setStep(InterceptorContext.InterceptorStep.END);
            this.endInterceptorContext();
        }
    }

    public static class InterceptorContext {
        private static ThreadLocal<InterceptorContext> instance = new ThreadLocal();
        private InterceptorStep step;
        private ActionInvocation invocation;
        private Object action;
        private Map<String, Map<String, Object>> fakeForms;
        private PolicyLookup policyLookup;
        private Field actionField;
        private Object form;
        private FormattableForm formattableForm;
        private boolean skipConversionErrors;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> autoParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> defaultParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> manualParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> noConversionFields;
        private Collection<InterceptorCommonLibrary.PairFieldUsage<?>> pairConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> setOnlyFields;

        public static InterceptorContext getInstance() {
            return instance.get();
        }

        public static void setInstance(InterceptorContext value) {
            instance.set(value);
        }

        protected InterceptorContext() {
            this.reset();
        }

        public void reset() {
            this.step = null;
            this.invocation = null;
            this.action = null;
            this.fakeForms = new HashMap<String, Map<String, Object>>();
            this.actionField = null;
            this.form = null;
            this.formattableForm = null;
            this.skipConversionErrors = false;
            this.autoParameterConversionFields = new ArrayList();
            this.defaultParameterConversionFields = new ArrayList();
            this.manualParameterConversionFields = new ArrayList();
            this.noConversionFields = new ArrayList();
            this.pairConversionFields = new ArrayList();
        }

        public InterceptorStep getStep() {
            return this.step;
        }

        public void setStep(InterceptorStep step) {
            this.step = step;
        }

        public ActionInvocation getInvocation() {
            return this.invocation;
        }

        public void setInvocation(ActionInvocation invocation) {
            this.invocation = invocation;
        }

        public Object getAction() {
            return this.action;
        }

        public void setAction(Object action) {
            this.action = action;
        }

        public Map<String, Map<String, Object>> getFakeForms() {
            return this.fakeForms;
        }

        public void setFakeForms(Map<String, Map<String, Object>> fakeForms) {
            this.fakeForms = fakeForms;
        }

        public PolicyLookup getPolicyLookup() {
            return this.policyLookup;
        }

        public void setPolicyLookup(PolicyLookup policyLookup) {
            this.policyLookup = policyLookup;
        }

        public Field getActionField() {
            return this.actionField;
        }

        public void setActionField(Field actionField) {
            this.actionField = actionField;
        }

        public Object getForm() {
            return this.form;
        }

        public void setForm(Object form) {
            this.form = form;
        }

        public FormattableForm getFormattableForm() {
            return this.formattableForm;
        }

        public void setFormattableForm(FormattableForm formattableForm) {
            this.formattableForm = formattableForm;
        }

        public boolean getSkipConversionErrors() {
            return this.skipConversionErrors;
        }

        public void setSkipConversionErrors(boolean skipConversionErrors) {
            this.skipConversionErrors = skipConversionErrors;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getAutoParameterConversionFields() {
            return this.autoParameterConversionFields;
        }

        public void setAutoParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> autoParameterConversionFields) {
            this.autoParameterConversionFields = autoParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getDefaultParameterConversionFields() {
            return this.defaultParameterConversionFields;
        }

        public void setDefaultParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> defaultParameterConversionFields) {
            this.defaultParameterConversionFields = defaultParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getManualParameterConversionFields() {
            return this.manualParameterConversionFields;
        }

        public void setManualParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> manualParameterConversionFields) {
            this.manualParameterConversionFields = manualParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getNoConversionFields() {
            return this.noConversionFields;
        }

        public void setNoConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> noConversionFields) {
            this.noConversionFields = noConversionFields;
        }

        public Collection<InterceptorCommonLibrary.PairFieldUsage<?>> getPairConversionFields() {
            return this.pairConversionFields;
        }

        public void setPairConversionFields(Collection<InterceptorCommonLibrary.PairFieldUsage<?>> pairConversionFields) {
            this.pairConversionFields = pairConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getSetOnlyFields() {
            return this.setOnlyFields;
        }

        public void setSetOnlyFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> setOnlyFields) {
            this.setOnlyFields = setOnlyFields;
        }

        public static enum InterceptorStep {
            START,
            FORM_PROCESSING_START,
            ANNOTATION_PARSING,
            FIELD_PROCESSING,
            MANUAL_FORMATTING,
            FORM_PROCESSING_END,
            FORMAT_WRITING,
            END;

        }
    }

    public static class FieldContext<T> {
        private static ThreadLocal<FieldContext<?>> instance = new ThreadLocal();
        private FieldStep step;
        private FormatMode formatMode;
        private InterceptorCommonLibrary.FieldUsage<T> fieldUsage;
        private InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage;
        private Field unformattedField;
        private InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries;
        private String fieldName;
        private T unformattedValue;
        private Collection<T> unformattedCollectionValue;
        private String formattedValue;
        private List<String> formattedMultipleValues;

        public static <T> FieldContext<T> getInstance() {
            return instance.get();
        }

        public static <T> void setInstance(FieldContext<T> value) {
            instance.set(value);
        }

        protected FieldContext() {
            this.reset();
        }

        public void reset() {
            this.step = null;
            this.formatMode = null;
            this.fieldUsage = null;
            this.pairFieldUsage = null;
            this.unformattedField = null;
            this.annountationEntries = null;
            this.fieldName = null;
            this.unformattedValue = null;
            this.unformattedCollectionValue = null;
            this.formattedValue = null;
            this.formattedMultipleValues = null;
        }

        public FieldStep getStep() {
            return this.step;
        }

        public void setStep(FieldStep step) {
            this.step = step;
        }

        public FormatMode getFormatMode() {
            return this.formatMode;
        }

        public void setFormatType(FormatMode formatMode) {
            this.formatMode = formatMode;
        }

        public InterceptorCommonLibrary.FieldUsage<T> getFieldUsage() {
            return this.fieldUsage;
        }

        public void setFieldUsage(InterceptorCommonLibrary.FieldUsage<T> fieldUsage) {
            this.fieldUsage = fieldUsage;
        }

        public InterceptorCommonLibrary.PairFieldUsage<T> getPairFieldUsage() {
            return this.pairFieldUsage;
        }

        public void setPairFieldUsage(InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage) {
            this.pairFieldUsage = pairFieldUsage;
        }

        public Field getUnformattedField() {
            return this.unformattedField;
        }

        public void setUnformattedField(Field unformattedField) {
            this.unformattedField = unformattedField;
        }

        public InterceptorCommonLibrary.AnnotationEntries<T> getAnnountationEntries() {
            return this.annountationEntries;
        }

        public void setAnnountationEntries(InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries) {
            this.annountationEntries = annountationEntries;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public T getUnformattedValue() {
            return this.unformattedValue;
        }

        public void setUnformattedValue(T unformattedValue) {
            this.unformattedValue = unformattedValue;
        }

        public Collection<T> getUnformattedCollectionValue() {
            return this.unformattedCollectionValue;
        }

        public void setUnformattedCollectionValue(Collection<T> unformattedCollectionValue) {
            this.unformattedCollectionValue = unformattedCollectionValue;
        }

        public String getFormattedValue() {
            return this.formattedValue;
        }

        public void setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
        }

        public List<String> getFormattedMultipleValues() {
            return this.formattedMultipleValues;
        }

        public void setFormattedMultipleValues(List<String> formattedMultipleValues) {
            this.formattedMultipleValues = formattedMultipleValues;
        }

        public static enum FieldStep {
            START,
            FORMATTING,
            END;

        }

        public static enum FormatMode {
            AUTO,
            DEFAULT,
            NONE,
            PAIR,
            SET_ONLY;

        }
    }
}

