/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import name.matthewgreet.strutscommons.annotation.DisableFormatting;
import name.matthewgreet.strutscommons.policy.CollectionConverter;
import name.matthewgreet.strutscommons.policy.Converter;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.DisplayFormatter;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultDisplayFormatter
implements DisplayFormatter {
    private Logger LOG = LogManager.getLogger(DefaultDisplayFormatter.class);
    private PolicyLookup policyLookup = null;

    protected <T> boolean checkFieldClass(Class<?> conversionClass, Class<?> fieldClass) {
        return InterceptorCommonLibrary.checkFieldClass(conversionClass, fieldClass);
    }

    protected boolean filterDisplayField(Field displayField) {
        boolean disableFound = false;
        for (Annotation annotation : displayField.getAnnotations()) {
            if (!(annotation instanceof DisableFormatting)) continue;
            disableFound = true;
            break;
        }
        return !disableFound;
    }

    protected void formatInit() {
        if (this.policyLookup == null) {
            this.policyLookup = DefaultPolicyLookup.getInstance();
        }
    }

    protected <T> InterceptorCommonLibrary.AnnotationEntries<T> getAnnotationEntries(Field displayField, PolicyLookup policyLookup) {
        return InterceptorCommonLibrary.getAnnotationEntries(displayField, policyLookup);
    }

    protected <T> CollectionConverter<?, T> getDefaultCollectionConverter(DisplayFieldUsage<T> displayFieldUsage) {
        return InterceptorCommonLibrary.getDefaultCollectionConverter(displayFieldUsage.getRecordField(), this.policyLookup);
    }

    protected <T> Converter<?, T> getDefaultConverter(DisplayFieldUsage<T> displayFieldUsage) {
        return InterceptorCommonLibrary.getDefaultConverter(displayFieldUsage.getRecordField(), this.policyLookup);
    }

    protected <T> Converter<?, T> getDefaultConverterFromArray(DisplayFieldUsage<T> displayFieldUsage) {
        return InterceptorCommonLibrary.getDefaultConverterFromArray(displayFieldUsage.getRecordField(), this.policyLookup);
    }

    protected <T> Converter<?, T> getDefaultConverterFromCollection(DisplayFieldUsage<T> displayFieldUsage) {
        return InterceptorCommonLibrary.getDefaultConverterFromCollection(displayFieldUsage.getRecordField(), this.policyLookup);
    }

    protected Collection<DisplayFieldSource> getDisplayFieldSources(Collection<Field> displayFields, Collection<Field> recordFields) {
        Map<String, Field> recordFieldLookup = recordFields.stream().collect(Collectors.toMap(f -> f.getName(), f -> f));
        ArrayList<DisplayFieldSource> result = new ArrayList<DisplayFieldSource>();
        for (Field displayField : displayFields) {
            Field recordField = recordFieldLookup.get(displayField.getName());
            if (recordField == null) continue;
            DisplayFieldSource displayFieldSource = new DisplayFieldSource();
            displayFieldSource.setDisplayField(displayField);
            displayFieldSource.setRecordField(recordField);
            result.add(displayFieldSource);
        }
        return result;
    }

    protected <T> DisplayFieldUsage<T> getDisplayFieldUsage(Field recordField, Field displayField, PolicyLookup policyLookup) {
        Class<Object> recordType;
        FieldCategory recordFieldCategory;
        Class<Object> displayType;
        FieldCategory displayFieldCategory;
        Converter<?, T> converter;
        CollectionConverter<?, T> collectionConverter;
        ConverterCategory converterCategory = ConverterCategory.DEFAULT;
        InterceptorCommonLibrary.AnnotationEntries<T> annotationEntries = this.getAnnotationEntries(displayField, policyLookup);
        if (annotationEntries.getCollectionConverter() != null) {
            collectionConverter = annotationEntries.getCollectionConverter().getCollectionConverter();
            converterCategory = ConverterCategory.COLLECTION;
        } else {
            collectionConverter = null;
        }
        if (annotationEntries.getConverter() != null) {
            converter = annotationEntries.getConverter().getConverter();
            converterCategory = ConverterCategory.SINGLE;
        } else {
            converter = null;
        }
        if (displayField.getType().isArray()) {
            displayFieldCategory = FieldCategory.ARRAY;
            displayType = displayField.getType().getComponentType();
        } else if (Collection.class.isAssignableFrom(displayField.getType())) {
            displayFieldCategory = FieldCategory.COLLECTION;
            displayType = this.getTypeFromCollectionField(displayField);
        } else {
            displayFieldCategory = FieldCategory.SINGLE;
            displayType = displayField.getType();
        }
        if (!String.class.isAssignableFrom(displayType)) {
            if (converterCategory == ConverterCategory.SINGLE || converterCategory == ConverterCategory.COLLECTION) {
                this.LOG.error("Annotated display fields must be a string, string array or string collection  display=" + displayField.getDeclaringClass().getName() + "  field=" + displayField.getName());
            }
            return null;
        }
        if (recordField.getType().isArray()) {
            recordFieldCategory = FieldCategory.ARRAY;
            recordType = recordField.getType().getComponentType();
        } else if (Collection.class.isAssignableFrom(recordField.getType())) {
            recordFieldCategory = FieldCategory.COLLECTION;
            recordType = this.getTypeFromCollectionField(recordField);
        } else {
            recordFieldCategory = FieldCategory.SINGLE;
            recordType = recordField.getType();
        }
        switch (converterCategory.ordinal()) {
            case 0: {
                boolean compatible = this.checkFieldClass(collectionConverter.getRecipientClass(), recordType);
                if (compatible) break;
                this.LOG.error("Annotation on display field does not match type of record field  display=" + displayField.getDeclaringClass().getName() + "  field=" + displayField.getName() + "  annotation=" + collectionConverter.getAnnotation().annotationType() + "  record=" + recordField.getDeclaringClass() + "  field=" + recordField.getName());
                return null;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean compatible = this.checkFieldClass(converter.getRecipientClass(), recordType);
                if (compatible) break;
                this.LOG.error("Annotation on display field does not match type of record field  display=" + displayField.getDeclaringClass().getName() + "  field=" + displayField.getName() + "  annotation=" + converter.getAnnotation().annotationType() + "  record=" + recordField.getDeclaringClass() + "  field=" + recordField.getName());
                return null;
            }
        }
        DisplayFieldUsage<Object> result = new DisplayFieldUsage<Object>();
        result.setAnnountationEntries(annotationEntries);
        result.setConverterCategory(converterCategory);
        result.setDisplayFieldCategory(displayFieldCategory);
        result.setDisplayField(displayField);
        result.setDisplayName(displayField.getName());
        result.setFieldType(recordType);
        result.setRecordFieldCategory(recordFieldCategory);
        result.setRecordField(recordField);
        result.setRecordName(recordField.getName());
        return result;
    }

    protected DisplayFormatMode getDisplayFormatMode(DisplayFieldUsage<?> displayFieldUsage) {
        switch (displayFieldUsage.getRecordFieldCategory().ordinal()) {
            case 0: {
                switch (displayFieldUsage.getDisplayFieldCategory().ordinal()) {
                    case 0: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                            case 1: 
                            case 2: {
                                return DisplayFormatMode.ARRAY_TO_ARRAY;
                            }
                        }
                    }
                    case 1: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                            case 1: 
                            case 2: {
                                return DisplayFormatMode.ARRAY_TO_COLLECTION;
                            }
                        }
                    }
                    case 2: {
                        return DisplayFormatMode.UNSUPPORTED;
                    }
                }
                break;
            }
            case 1: {
                switch (displayFieldUsage.getDisplayFieldCategory().ordinal()) {
                    case 0: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                            case 1: 
                            case 2: {
                                return DisplayFormatMode.COLLECTION_TO_ARRAY;
                            }
                        }
                    }
                    case 1: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                            case 1: 
                            case 2: {
                                return DisplayFormatMode.COLLECTION_TO_COLLECTION;
                            }
                        }
                    }
                    case 2: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: 
                            case 1: {
                                return DisplayFormatMode.COLLECTION_TO_SINGLE;
                            }
                            case 2: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                switch (displayFieldUsage.getDisplayFieldCategory().ordinal()) {
                    case 0: 
                    case 1: {
                        return DisplayFormatMode.UNSUPPORTED;
                    }
                    case 2: {
                        switch (displayFieldUsage.getConverterCategory().ordinal()) {
                            case 0: {
                                return DisplayFormatMode.UNSUPPORTED;
                            }
                            case 1: 
                            case 2: {
                                return DisplayFormatMode.SINGLE_TO_SINGLE;
                            }
                        }
                    }
                }
            }
        }
        return DisplayFormatMode.UNSUPPORTED;
    }

    protected Collection<Field> getProperties(Class<?> type) {
        return InterceptorCommonLibrary.getProperties(type);
    }

    protected <T> Class<T> getTypeFromCollectionField(Field displayField) {
        return InterceptorCommonLibrary.getTypeFromCollectionField(displayField);
    }

    protected <T> Collection<T> makeCollectionForRecipient(Class<?> recipientClass) {
        return InterceptorCommonLibrary.makeCollectionForRecipient(recipientClass);
    }

    protected <T> void processDisplayFieldUsageArrayToArray(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        String formattedValue;
        int i;
        ArrayList<Object> unformattedValues = new ArrayList<Object>();
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            Object rawValue = displayFieldUsage.getRecordField().get(record);
            if (rawValue != null) {
                int length = Array.getLength(rawValue);
                for (i = 0; i < length; ++i) {
                    unformattedValues.add(Array.get(rawValue, i));
                }
            }
        }
        Converter converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverterFromArray(displayFieldUsage);
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        if (converter != null) {
            for (Object e : unformattedValues) {
                if (e != null || converter.getProcessNoValue()) {
                    formattedValue = converter.format(e);
                    formattedValues.add(formattedValue);
                    continue;
                }
                formattedValues.add("");
            }
        } else if (String.class.isAssignableFrom(displayFieldUsage.getFieldType())) {
            for (Object e : unformattedValues) {
                if (e != null) {
                    formattedValue = (String)e;
                    formattedValues.add(formattedValue);
                    continue;
                }
                formattedValues.add("");
            }
        }
        String[] finalValue = new String[formattedValues.size()];
        i = 0;
        Iterator iterator = formattedValues.iterator();
        while (iterator.hasNext()) {
            String string;
            finalValue[i] = string = (String)iterator.next();
            ++i;
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageArrayToCollection(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        ArrayList<Object> unformattedValues = new ArrayList<Object>();
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            Object rawValue = displayFieldUsage.getRecordField().get(record);
            if (rawValue != null) {
                int length = Array.getLength(rawValue);
                for (int i = 0; i < length; ++i) {
                    unformattedValues.add(Array.get(rawValue, i));
                }
            }
        }
        Converter converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverterFromArray(displayFieldUsage);
        }
        Collection<T> finalValue = this.makeCollectionForRecipient(displayFieldUsage.getDisplayField().getType());
        if (converter != null) {
            for (Object e : unformattedValues) {
                if (e != null || converter.getProcessNoValue()) {
                    String formattedValue = converter.format(e);
                    finalValue.add(formattedValue);
                    continue;
                }
                finalValue.add("");
            }
        } else if (String.class.isAssignableFrom(displayFieldUsage.getFieldType())) {
            for (Object e : unformattedValues) {
                if (e != null) {
                    String formattedValue = (String)e;
                    finalValue.add(formattedValue);
                    continue;
                }
                finalValue.add("");
            }
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageArrayToSingle(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Object unformattedValue;
        ArrayList<Object> unformattedValues = new ArrayList<Object>();
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            Object rawValue = displayFieldUsage.getRecordField().get(record);
            if (rawValue != null) {
                int length = Array.getLength(rawValue);
                for (int i = 0; i < length; ++i) {
                    unformattedValues.add(Array.get(rawValue, i));
                }
            }
        }
        Converter converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverter(displayFieldUsage);
        }
        String finalValue = "";
        if (converter != null && unformattedValues.size() > 0) {
            Object unformattedValue2 = unformattedValues.get(0);
            if (unformattedValue2 != null || converter.getProcessNoValue()) {
                finalValue = converter.format(unformattedValue2);
            }
        } else if (String.class.isAssignableFrom(displayFieldUsage.getFieldType()) && (unformattedValue = unformattedValues.get(0)) != null) {
            finalValue = (String)unformattedValue;
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageCollectionToArray(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        String formattedValue;
        Collection unformattedValues;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValues = (Collection)displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValues = null;
        }
        Converter converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverterFromCollection(displayFieldUsage);
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        if (converter != null && unformattedValues != null) {
            for (Object unformattedValue : unformattedValues) {
                if (unformattedValue != null || converter.getProcessNoValue()) {
                    formattedValue = converter.format(unformattedValue);
                    formattedValues.add(formattedValue);
                    continue;
                }
                formattedValues.add("");
            }
        } else if (unformattedValues != null && String.class.isAssignableFrom(displayFieldUsage.getFieldType())) {
            for (Object unformattedValue : unformattedValues) {
                if (unformattedValue != null) {
                    formattedValue = (String)unformattedValue;
                    formattedValues.add(formattedValue);
                    continue;
                }
                formattedValues.add("");
            }
        }
        String[] finalValue = new String[formattedValues.size()];
        int i = 0;
        Iterator iterator = formattedValues.iterator();
        while (iterator.hasNext()) {
            String formattedValue2;
            finalValue[i] = formattedValue2 = (String)iterator.next();
            ++i;
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageCollectionToCollection(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Collection unformattedValues;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValues = (Collection)displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValues = null;
        }
        Converter converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverterFromCollection(displayFieldUsage);
        }
        Collection<T> finalValue = this.makeCollectionForRecipient(displayFieldUsage.getDisplayField().getType());
        if (converter != null && unformattedValues != null) {
            for (Object unformattedValue : unformattedValues) {
                if (unformattedValue != null || converter.getProcessNoValue()) {
                    String formattedValue = converter.format(unformattedValue);
                    finalValue.add(formattedValue);
                    continue;
                }
                finalValue.add("");
            }
        } else if (unformattedValues != null && String.class.isAssignableFrom(displayFieldUsage.getFieldType())) {
            for (Object unformattedValue : unformattedValues) {
                if (unformattedValue != null) {
                    String formattedValue = (String)unformattedValue;
                    finalValue.add(formattedValue);
                    continue;
                }
                finalValue.add("");
            }
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageCollectionToSingle(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Collection unformattedValue;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValue = (Collection)displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValue = null;
        }
        CollectionConverter<?, T> collectionconverter = null;
        if (displayFieldUsage.getAnnountationEntries().getCollectionConverter() != null) {
            collectionconverter = displayFieldUsage.getAnnountationEntries().getCollectionConverter().getCollectionConverter();
        }
        if (collectionconverter == null) {
            collectionconverter = this.getDefaultCollectionConverter(displayFieldUsage);
        }
        String formattedValue = collectionconverter != null ? (unformattedValue != null && unformattedValue.size() > 0 || collectionconverter.getProcessNoValue() ? collectionconverter.format(unformattedValue) : "") : "";
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, formattedValue);
    }

    protected <T> void processDisplayFieldUsageOther1(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther10(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther2(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther3(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther4(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther5(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther6(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther7(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther8(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageOther9(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    protected <T> void processDisplayFieldUsageSingleToArray(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Object unformattedValue;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValue = displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValue = null;
        }
        Converter<?, Object> converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverterFromArray(displayFieldUsage);
        }
        String formattedValue = converter != null ? (unformattedValue != null || converter.getProcessNoValue() ? converter.format(unformattedValue) : "") : (unformattedValue != null && String.class.isAssignableFrom(unformattedValue.getClass()) ? (String)unformattedValue : "");
        String[] finalValue = formattedValue.length() > 0 ? new String[]{formattedValue} : new String[]{};
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageSingleToCollection(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Object unformattedValue;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValue = displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValue = null;
        }
        Converter<?, Object> converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverter(displayFieldUsage);
        }
        String formattedValue = converter != null ? (unformattedValue != null || converter.getProcessNoValue() ? converter.format(unformattedValue) : "") : (unformattedValue != null && String.class.isAssignableFrom(unformattedValue.getClass()) ? (String)unformattedValue : "");
        Collection<T> finalValue = this.makeCollectionForRecipient(displayFieldUsage.getDisplayField().getType());
        if (formattedValue.length() > 0) {
            finalValue.add(formattedValue);
        }
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, finalValue);
    }

    protected <T> void processDisplayFieldUsageSingleToSingle(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
        Object unformattedValue;
        if (record != null) {
            displayFieldUsage.getRecordField().setAccessible(true);
            unformattedValue = displayFieldUsage.getRecordField().get(record);
        } else {
            unformattedValue = null;
        }
        Converter<?, Object> converter = null;
        if (displayFieldUsage.getAnnountationEntries().getConverter() != null) {
            converter = displayFieldUsage.getAnnountationEntries().getConverter().getConverter();
        }
        if (converter == null) {
            converter = this.getDefaultConverter(displayFieldUsage);
        }
        String formattedValue = converter != null ? (unformattedValue != null || converter.getProcessNoValue() ? converter.format(unformattedValue) : "") : (unformattedValue != null && String.class.isAssignableFrom(displayFieldUsage.getFieldType()) ? (String)unformattedValue : "");
        displayFieldUsage.getDisplayField().setAccessible(true);
        displayFieldUsage.getDisplayField().set(display, formattedValue);
    }

    protected <T> void processDisplayFieldUsageUnsupported(Object record, Object display, DisplayFieldUsage<T> displayFieldUsage) throws Exception {
    }

    public PolicyLookup getPolicyLookup() {
        return this.policyLookup;
    }

    public void setPolicyLookup(PolicyLookup policyLookup) {
        this.policyLookup = policyLookup;
    }

    @Override
    public void updateDisplay(Class<?> recordClass, Object record, Object display) {
        this.formatInit();
        Collection<Field> recordFields = this.getProperties(recordClass);
        Collection displayFields = this.getProperties(display.getClass());
        displayFields = displayFields.stream().filter(this::filterDisplayField).collect(Collectors.toList());
        Collection<DisplayFieldSource> displayFieldSources = this.getDisplayFieldSources(displayFields, recordFields);
        for (DisplayFieldSource displayFieldSource : displayFieldSources) {
            Field displayField = displayFieldSource.getDisplayField();
            Field recordField = displayFieldSource.getRecordField();
            Object unformattedValue = null;
            try {
                DisplayFieldUsage displayFieldUsage = this.getDisplayFieldUsage(recordField, displayField, this.policyLookup);
                if (displayFieldUsage == null) continue;
                if (record != null) {
                    displayFieldUsage.getRecordField().setAccessible(true);
                    unformattedValue = displayFieldUsage.getRecordField().get(record);
                } else {
                    unformattedValue = "";
                }
                DisplayFormatMode conversionMode = this.getDisplayFormatMode(displayFieldUsage);
                switch (conversionMode.ordinal()) {
                    case 4: {
                        this.processDisplayFieldUsageArrayToArray(record, display, displayFieldUsage);
                        break;
                    }
                    case 5: {
                        this.processDisplayFieldUsageArrayToCollection(record, display, displayFieldUsage);
                        break;
                    }
                    case 3: {
                        this.processDisplayFieldUsageArrayToSingle(record, display, displayFieldUsage);
                        break;
                    }
                    case 7: {
                        this.processDisplayFieldUsageCollectionToArray(record, display, displayFieldUsage);
                        break;
                    }
                    case 8: {
                        this.processDisplayFieldUsageCollectionToCollection(record, display, displayFieldUsage);
                        break;
                    }
                    case 6: {
                        this.processDisplayFieldUsageCollectionToSingle(record, display, displayFieldUsage);
                        break;
                    }
                    case 9: {
                        this.processDisplayFieldUsageOther1(record, display, displayFieldUsage);
                        break;
                    }
                    case 10: {
                        this.processDisplayFieldUsageOther2(record, display, displayFieldUsage);
                        break;
                    }
                    case 11: {
                        this.processDisplayFieldUsageOther3(record, display, displayFieldUsage);
                        break;
                    }
                    case 12: {
                        this.processDisplayFieldUsageOther4(record, display, displayFieldUsage);
                        break;
                    }
                    case 13: {
                        this.processDisplayFieldUsageOther5(record, display, displayFieldUsage);
                        break;
                    }
                    case 14: {
                        this.processDisplayFieldUsageOther6(record, display, displayFieldUsage);
                        break;
                    }
                    case 15: {
                        this.processDisplayFieldUsageOther7(record, display, displayFieldUsage);
                        break;
                    }
                    case 16: {
                        this.processDisplayFieldUsageOther8(record, display, displayFieldUsage);
                        break;
                    }
                    case 17: {
                        this.processDisplayFieldUsageOther9(record, display, displayFieldUsage);
                        break;
                    }
                    case 18: {
                        this.processDisplayFieldUsageOther10(record, display, displayFieldUsage);
                        break;
                    }
                    case 1: {
                        this.processDisplayFieldUsageSingleToArray(record, display, displayFieldUsage);
                        break;
                    }
                    case 2: {
                        this.processDisplayFieldUsageSingleToCollection(record, display, displayFieldUsage);
                        break;
                    }
                    case 0: {
                        this.processDisplayFieldUsageSingleToSingle(record, display, displayFieldUsage);
                        break;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.LOG.error("Security violation when accessing record or setting display   display=" + display.getClass() + "  field=" + displayField.getName() + "  record=" + record.getClass() + "  field=" + recordField.getName(), (Throwable)e);
            }
            catch (Exception e) {
                this.LOG.error("Formatter failed   display=" + display.getClass() + "  field=" + displayField.getName() + "  value=" + unformattedValue, (Throwable)e);
            }
        }
    }

    public static class DisplayFieldUsage<T> {
        private InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries;
        private ConverterCategory converterCategory;
        private Class<T> fieldType;
        private FieldCategory recordFieldCategory;
        private Field recordField;
        private String recordName;
        private FieldCategory displayFieldCategory;
        private Field displayField;
        private String displayName;

        public InterceptorCommonLibrary.AnnotationEntries<T> getAnnountationEntries() {
            return this.annountationEntries;
        }

        public void setAnnountationEntries(InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries) {
            this.annountationEntries = annountationEntries;
        }

        public Class<T> getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(Class<T> fieldType) {
            this.fieldType = fieldType;
        }

        public ConverterCategory getConverterCategory() {
            return this.converterCategory;
        }

        public void setConverterCategory(ConverterCategory converterCategory) {
            this.converterCategory = converterCategory;
        }

        public FieldCategory getRecordFieldCategory() {
            return this.recordFieldCategory;
        }

        public void setRecordFieldCategory(FieldCategory recordFieldCategory) {
            this.recordFieldCategory = recordFieldCategory;
        }

        public Field getRecordField() {
            return this.recordField;
        }

        public void setRecordField(Field recordField) {
            this.recordField = recordField;
        }

        public String getRecordName() {
            return this.recordName;
        }

        public void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public FieldCategory getDisplayFieldCategory() {
            return this.displayFieldCategory;
        }

        public void setDisplayFieldCategory(FieldCategory displayFieldCategory) {
            this.displayFieldCategory = displayFieldCategory;
        }

        public Field getDisplayField() {
            return this.displayField;
        }

        public void setDisplayField(Field displayField) {
            this.displayField = displayField;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class DisplayFieldSource {
        private Field displayField;
        private Field recordField;

        public Field getDisplayField() {
            return this.displayField;
        }

        public Field getRecordField() {
            return this.recordField;
        }

        public void setDisplayField(Field displayField) {
            this.displayField = displayField;
        }

        public void setRecordField(Field recordField) {
            this.recordField = recordField;
        }
    }

    public static enum ConverterCategory {
        COLLECTION,
        DEFAULT,
        SINGLE;

    }

    public static enum FieldCategory {
        ARRAY,
        COLLECTION,
        SINGLE;

    }

    public static enum DisplayFormatMode {
        SINGLE_TO_SINGLE,
        SINGLE_TO_ARRAY,
        SINGLE_TO_COLLECTION,
        ARRAY_TO_SINGLE,
        ARRAY_TO_ARRAY,
        ARRAY_TO_COLLECTION,
        COLLECTION_TO_SINGLE,
        COLLECTION_TO_ARRAY,
        COLLECTION_TO_COLLECTION,
        OTHER1,
        OTHER2,
        OTHER3,
        OTHER4,
        OTHER5,
        OTHER6,
        OTHER7,
        OTHER8,
        OTHER9,
        OTHER10,
        UNSUPPORTED;

    }
}

