/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required;

public class ValidationResult {
    private boolean success;
    private String message;
    private String messageKey;
    private Required.MessageType messageType;
    private boolean shortCircuit;

    public static ValidationResult makeSuccessResult() {
        ValidationResult result = new ValidationResult();
        result.setSuccess(true);
        return result;
    }

    public static ValidationResult makeFailureResult() {
        ValidationResult result = new ValidationResult();
        result.setSuccess(false);
        return new ValidationResult(false, null, null, null);
    }

    public static ValidationResult makeFailureWithMessageResult(String message, Required.MessageType messageType) {
        ValidationResult result = new ValidationResult();
        result.setSuccess(false);
        result.setMessage(message);
        result.setMessageType(messageType);
        return result;
    }

    public static ValidationResult makeFailureWithMessageKeyResult(String messageKey, Required.MessageType messageType) {
        ValidationResult result = new ValidationResult();
        result.setSuccess(false);
        result.setMessageKey(messageKey);
        result.setMessageType(messageType);
        return result;
    }

    public ValidationResult() {
        this.success = false;
        this.message = null;
        this.messageKey = null;
        this.messageType = null;
        this.shortCircuit = false;
    }

    public ValidationResult(boolean success, String message, String messageKey, Required.MessageType messageType) {
        this.success = success;
        this.message = message;
        this.messageKey = messageKey;
        this.messageType = messageType;
        this.shortCircuit = false;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Required.MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(Required.MessageType messageType) {
        this.messageType = messageType;
    }

    public boolean getShortCircuit() {
        return this.shortCircuit;
    }

    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }
}

