/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import java.util.Collection;
import java.util.Iterator;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.StringCSVConversion;
import name.matthewgreet.strutscommons.policy.AbstractDefaultCollectionConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.IntegerCSVConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringCSVConverter
extends AbstractDefaultCollectionConverterSupport<StringCSVConversion, String> {
    private static final Logger LOG = LogManager.getLogger(IntegerCSVConverter.class);
    @StringCSVConversion
    private static boolean annotationPlaceholder;

    @Override
    protected StringCSVConversion makeDefaultAnnotation() {
        try {
            return StringCSVConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(StringCSVConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Collection<String> unformattedValues) throws Exception {
        String result = "";
        Iterator<String> iterator = unformattedValues.iterator();
        while (iterator.hasNext()) {
            String rawValue;
            String value = rawValue = iterator.next();
            if (result.length() > 0) {
                result = result + ((StringCSVConversion)this.getAnnotation()).separator();
            }
            if (value == null) continue;
            result = result + value;
        }
        return result;
    }

    @Override
    public Class<String> getRecipientClass() {
        return String.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return Required.MessageType.MESSAGE;
    }

    @Override
    public String getMessage() {
        return "";
    }

    @Override
    public String getMessageKey() {
        return "";
    }

    @Override
    public String getRecipientFieldName() {
        return ((StringCSVConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<String> convert(String formValue, Class<?> recipientFieldClass, Class<? extends String> recipientClass) throws Exception {
        String[] values;
        Collection parsedValue = this.makeCollectionForRecipient(recipientFieldClass);
        for (String value : values = formValue.split(((StringCSVConversion)this.getAnnotation()).separator(), -1)) {
            if (formValue.trim().length() <= 0) continue;
            String workingValue = value;
            if (((StringCSVConversion)this.getAnnotation()).trim()) {
                workingValue = workingValue.trim();
            }
            parsedValue.add(workingValue);
        }
        return ConversionResult.makeSuccessCollectionResult(parsedValue);
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

