/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FloatConverter
extends AbstractDefaultConverterSupport<FloatConversion, Float> {
    private static final Logger LOG = LogManager.getLogger(FloatConverter.class);
    @FloatConversion
    private static boolean annotationPlaceholder;

    @Override
    protected FloatConversion makeDefaultAnnotation() {
        try {
            return FloatConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(FloatConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Float unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Float> getRecipientClass() {
        return Float.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((FloatConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((FloatConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((FloatConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((FloatConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Float> convert(String formValue, Class<? extends Float> recipientClass) throws Exception {
        try {
            float parsedValue = Float.parseFloat(formValue);
            return ConversionResult.makeSuccessResult(Float.valueOf(parsedValue));
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

