/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DoubleConverter
extends AbstractDefaultConverterSupport<DoubleConversion, Double> {
    private static final Logger LOG = LogManager.getLogger(DoubleConverter.class);
    @DoubleConversion
    private static boolean annotationPlaceholder;

    @Override
    protected DoubleConversion makeDefaultAnnotation() {
        try {
            return DoubleConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(DoubleConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Double unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Double> getRecipientClass() {
        return Double.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((DoubleConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((DoubleConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((DoubleConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((DoubleConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Double> convert(String formValue, Class<? extends Double> recipientClass) throws Exception {
        try {
            double parsedValue = Double.parseDouble(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

