/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CharacterConverter
extends AbstractDefaultConverterSupport<CharacterConversion, Character> {
    private static final Logger LOG = LogManager.getLogger(CharacterConverter.class);
    @CharacterConversion
    private static boolean annotationPlaceholder;

    @Override
    protected CharacterConversion makeDefaultAnnotation() {
        try {
            return CharacterConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(CharacterConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Character unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Character> getRecipientClass() {
        return Character.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((CharacterConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((CharacterConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((CharacterConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((CharacterConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Character> convert(String formValue, Class<? extends Character> recipientClass) throws Exception {
        char parsedValue = formValue.charAt(0);
        return ConversionResult.makeSuccessResult(Character.valueOf(parsedValue));
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

