/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BooleanConverter
extends AbstractDefaultConverterSupport<BooleanConversion, Boolean> {
    private static final Logger LOG = LogManager.getLogger(BooleanConverter.class);
    @BooleanConversion
    private static boolean annotationPlaceholder;

    @Override
    protected BooleanConversion makeDefaultAnnotation() {
        try {
            return BooleanConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(BooleanConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Boolean unformattedValue) throws Exception {
        if (unformattedValue.booleanValue()) {
            return "1";
        }
        return "";
    }

    @Override
    public Class<Boolean> getRecipientClass() {
        return Boolean.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return Required.MessageType.MESSAGE;
    }

    @Override
    public String getMessage() {
        return "";
    }

    @Override
    public String getMessageKey() {
        return "";
    }

    @Override
    public String getRecipientFieldName() {
        return ((BooleanConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Boolean> convert(String fieldValue, Class<? extends Boolean> recipientClass) throws Exception {
        boolean parsedValue = false;
        if (fieldValue.equalsIgnoreCase("on")) {
            parsedValue = true;
        } else if (fieldValue.length() > 0) {
            char firstCharacter = fieldValue.charAt(0);
            switch (firstCharacter) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    parsedValue = true;
                }
            }
        }
        return ConversionResult.makeSuccessResult(parsedValue);
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

