/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import java.math.BigDecimal;
import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BigDecimalConverter
extends AbstractDefaultConverterSupport<BigDecimalConversion, BigDecimal> {
    private static final Logger LOG = LogManager.getLogger(BigDecimalConverter.class);
    @BigDecimalConversion
    private static boolean annotationPlaceholder;

    @Override
    protected BigDecimalConversion makeDefaultAnnotation() {
        try {
            return BigDecimalConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(BigDecimalConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(BigDecimal unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<BigDecimal> getRecipientClass() {
        return BigDecimal.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((BigDecimalConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((BigDecimalConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((BigDecimalConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((BigDecimalConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<BigDecimal> convert(String formValue, Class<? extends BigDecimal> recipientClass) throws Exception {
        try {
            BigDecimal parsedValue = new BigDecimal(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

