/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import name.matthewgreet.strutscommons.util.DefaultFormFormatter;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.FormFormatter;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FormFormatterInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 2689404505465349761L;
    @Inject(value="name.matthewgreet.strutscommons.accept_classes", required=false)
    private String acceptClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.accept_packages", required=false)
    private String acceptPackages = "";
    @Inject(value="name.matthewgreet.strutscommons.classpath_scanning_replace_built_in", required=false)
    private String classpathScanningReplaceBuiltIn = "false";
    @Inject(value="name.matthewgreet.strutscommons.enable_classpath_scanning", required=false)
    private String enableClassScanning = "false";
    @Inject(value="name.matthewgreet.strutscommons.reject_classes", required=false)
    private String rejectClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.reject_packages", required=false)
    private String rejectPackages = "";
    private boolean disabled = false;
    private Logger LOG = LogManager.getLogger(FormFormatterInterceptor.class);

    protected FormFormatter makeFormFormatLibrary() {
        return new DefaultFormFormatter();
    }

    protected PolicyLookup makePolicyLookup() {
        DefaultPolicyLookup.Configuration configuration = new DefaultPolicyLookup.Configuration();
        configuration.setAcceptClasses(this.acceptClasses);
        configuration.setAcceptPackages(this.acceptPackages);
        configuration.setClasspathScanningReplaceBuiltIn(Boolean.parseBoolean(this.classpathScanningReplaceBuiltIn));
        configuration.setEnableClasspathScanning(Boolean.parseBoolean(this.enableClassScanning));
        configuration.setRejectClasses(this.rejectClasses);
        configuration.setRejectPackages(this.rejectPackages);
        return DefaultPolicyLookup.getInstance(configuration);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled) {
            invocation.addPreResultListener((PreResultListener)new FormFormatterPreResultListener());
        }
        return invocation.invoke();
    }

    public class FormFormatterPreResultListener
    implements PreResultListener {
        public void beforeResult(ActionInvocation invocation, String resultCode) {
            PolicyLookup policyLookup = FormFormatterInterceptor.this.makePolicyLookup();
            FormFormatter formFormatLibrary = FormFormatterInterceptor.this.makeFormFormatLibrary();
            formFormatLibrary.formatForms(policyLookup);
        }
    }
}

