/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import name.matthewgreet.strutscommons.action.BrowserTabAware;
import name.matthewgreet.strutscommons.util.ServletLibrary;

public class BrowserTabInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -1555224920319813415L;
    private boolean disabled;

    private void setBrowserTabId(BrowserTabAware browserTabAware, ActionInvocation invocation) {
        Cookie[] cookies;
        try {
            HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            cookies = request.getCookies();
        }
        catch (Exception e) {
            cookies = null;
        }
        String cookieValue = ServletLibrary.getBrowserTabId(cookies);
        cookieValue = cookieValue != null ? cookieValue : "";
        browserTabAware.setTabId(cookieValue);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled && invocation.getAction() instanceof BrowserTabAware) {
            this.setBrowserTabId((BrowserTabAware)invocation.getAction(), invocation);
        }
        String result = invocation.invoke();
        return result;
    }
}

