/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.form.Form;
import name.matthewgreet.strutscommons.util.IdListFinder;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.ListCacheRecordComparator;
import name.matthewgreet.strutscommons.util.ListFinder;
import name.matthewgreet.strutscommons.util.ListSizeFinder;
import name.matthewgreet.strutscommons.util.PageByIndexRangeFinder;

public abstract class AbstractFindListMultiModeActionSupport<M extends Serializable, K extends Serializable, T extends Serializable, F extends Form>
extends AbstractFormDrivenActionSupport<F> {
    private static final long serialVersionUID = 7571697364740160930L;

    protected abstract FindListMultiModeResponse<M, K, T> getFindCommand(M var1) throws Exception;

    protected abstract FindListMultiModeConfig getFindListMultiModeConfig();

    protected ListCacheRecordComparator<T> getItemSorter() {
        return null;
    }

    protected abstract ListCache<M, K, T> getListCache();

    protected abstract ListCache<?, ?, M> getMasterListCache();

    protected String translateFinderException(ListFinder<M, T> listFinderCommand, IdListFinder<M, K> idListFinderCommand, ListSizeFinder<M> listSizeFinderCommand, Exception e) {
        return null;
    }

    public String execute() throws Exception {
        FindListMultiModeConfig config = this.getFindListMultiModeConfig();
        FindListMultiModeResponse<Object, K, T> findResponse = null;
        List<T> list = null;
        ListFinder<Object, T> listFinderCommand = null;
        List<K> ids = null;
        IdListFinder<Object, K> idListFinderCommand = null;
        int listSize = 0;
        ListSizeFinder<Object> listSizeFinderCommand = null;
        PageByIndexRangeFinder<Object, T> pageByIndexRangeFinderCommand = null;
        String errorMessage = null;
        boolean matchFound = false;
        ListCache<?, ?, M> masterListCache = this.getMasterListCache();
        ListCache<Object, K, T> listCache = this.getListCache();
        try {
            Object selectedMaster = masterListCache != null && masterListCache != listCache ? (Object)masterListCache.getSelected() : null;
            findResponse = this.getFindCommand(selectedMaster);
            ListCache.PaginationMode paginationMode = findResponse.getPaginationMode();
            if (!findResponse.getRejected()) {
                switch (paginationMode) {
                    case BASE_RECORD_LIST: {
                        listFinderCommand = findResponse.getFullListFinderCommand();
                        if (findResponse.getFullList() == null) {
                            list = listFinderCommand.getList(selectedMaster);
                            if (list == null) {
                                list = new ArrayList<T>();
                            }
                        } else {
                            list = findResponse.getFullList();
                        }
                        matchFound = list.size() > 0;
                        break;
                    }
                    case FULL_LIST: {
                        listFinderCommand = findResponse.getFullListFinderCommand();
                        if (findResponse.getFullList() == null) {
                            list = listFinderCommand.getList(selectedMaster);
                            if (list == null) {
                                list = new ArrayList<T>();
                            }
                        } else {
                            list = findResponse.getFullList();
                        }
                        matchFound = list.size() > 0;
                        break;
                    }
                    case PAGE_BY_IDS: {
                        idListFinderCommand = findResponse.getIdListFinderCommand();
                        if (findResponse.getIdList() == null) {
                            ids = idListFinderCommand.getIds(selectedMaster);
                            if (ids == null) {
                                ids = new ArrayList<K>();
                            }
                        } else {
                            ids = findResponse.getIdList();
                        }
                        matchFound = ids != null && ids.size() > 0;
                        break;
                    }
                    case PAGE_BY_INDEX_RANGE: {
                        listSizeFinderCommand = findResponse.getListSizeFinderCommand();
                        pageByIndexRangeFinderCommand = findResponse.getPageByIndexRangeFinder();
                        listSize = findResponse.getListSize() == null ? listSizeFinderCommand.getSize(selectedMaster) : findResponse.getListSize().intValue();
                        boolean bl = matchFound = listSize > 0;
                    }
                }
                if (!config.getRejectNoMatch() || matchFound) {
                    switch (paginationMode) {
                        case BASE_RECORD_LIST: {
                            listCache.setBaseRecordListAndFinder(list, listFinderCommand);
                            break;
                        }
                        case FULL_LIST: {
                            listCache.setListAndFinder(list, listFinderCommand);
                            break;
                        }
                        case PAGE_BY_IDS: {
                            listCache.setIdListAndFinder(ids, idListFinderCommand);
                            break;
                        }
                        case PAGE_BY_INDEX_RANGE: {
                            listCache.setListSizeAndFinder(listSize, listSizeFinderCommand, pageByIndexRangeFinderCommand);
                        }
                    }
                    ListCacheRecordComparator<T> itemSorter = this.getItemSorter();
                    if (itemSorter != null) {
                        listCache.setItemSorter(itemSorter);
                    }
                } else {
                    this.addActionError(config.getRejectMessage());
                }
            }
        }
        catch (Exception e) {
            errorMessage = this.translateFinderException(listFinderCommand, idListFinderCommand, listSizeFinderCommand, e);
            if (errorMessage == null || errorMessage.length() == 0) {
                errorMessage = "System failure: " + e.getMessage();
            }
            this.getLogger().error(errorMessage, (Throwable)e);
            this.addActionError(errorMessage);
        }
        if (findResponse != null) {
            for (String message : findResponse.getMessages()) {
                this.addActionMessage(message);
            }
            for (String errorMessage2 : findResponse.getErrors()) {
                this.addActionError(errorMessage2);
            }
            if (!findResponse.getRejected()) {
                return findResponse.getSuccessResultName();
            }
            return findResponse.getFailureResultName();
        }
        return "error";
    }

    public static class FindListMultiModeConfig {
        private boolean rejectNoMatch = false;
        private String rejectMessage = "No results found";

        public boolean getRejectNoMatch() {
            return this.rejectNoMatch;
        }

        public void setRejectNoMatch(boolean value) {
            this.rejectNoMatch = value;
        }

        public String getRejectMessage() {
            return this.rejectMessage;
        }

        public void setRejectMessage(String value) {
            this.rejectMessage = value;
        }
    }

    public static class FindListMultiModeResponse<M extends Serializable, K extends Serializable, T extends Serializable> {
        private boolean rejected = true;
        private String failureResultName = "input";
        private String successResultName = "success";
        private String successSingleForwardName = "successsingle";
        private ListFinder<M, T> fullListFinderCommand;
        private List<T> fullList;
        private IdListFinder<M, K> idListFinderCommand;
        private List<K> idList;
        private ListSizeFinder<M> listSizeFinderCommand;
        private PageByIndexRangeFinder<M, T> pageByIndexRangeFinder;
        private Integer listSize;
        private boolean useSuccessSingle = false;
        private ListCache.PaginationMode paginationMode;
        private Collection<String> errors = new ArrayList<String>();
        private Collection<String> messages = new ArrayList<String>();

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeFailureResponse(String message) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setRejected(true);
            result.addErrorMessage(message);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessBaseRecordListResponse(ListFinder<M, T> finderCommand) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setFullList(null);
            result.setFullListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.BASE_RECORD_LIST);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessBaseRecordListWithResultsResponse(ListFinder<M, T> finderCommand, List<T> resultList) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setFullList(resultList);
            result.setFullListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.BASE_RECORD_LIST);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessFullListResponse(ListFinder<M, T> finderCommand) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setFullList(null);
            result.setFullListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.FULL_LIST);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessFullListWithResultsResponse(ListFinder<M, T> finderCommand, List<T> resultList) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setFullList(resultList);
            result.setFullListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.FULL_LIST);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessIdListResponse(IdListFinder<M, K> finderCommand) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setIdList(null);
            result.setIdListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.PAGE_BY_IDS);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessIdListWithResultsResponse(IdListFinder<M, K> finderCommand, List<K> idList) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setIdList(idList);
            result.setIdListFinderCommand(finderCommand);
            result.setPaginationMode(ListCache.PaginationMode.PAGE_BY_IDS);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessIndexListResponse(ListSizeFinder<M> listSizeFinderCommand, PageByIndexRangeFinder<M, T> pageByIndexFinderCommand) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setListSize(null);
            result.setListSizeFinderCommand(listSizeFinderCommand);
            result.setPageByIndexRangeFinder(pageByIndexFinderCommand);
            result.setPaginationMode(ListCache.PaginationMode.PAGE_BY_INDEX_RANGE);
            result.setRejected(false);
            return result;
        }

        public static <M extends Serializable, K extends Serializable, T extends Serializable> FindListMultiModeResponse<M, K, T> makeSuccessIndexListWithResultsResponse(ListSizeFinder<M> listSizeFinderCommand, PageByIndexRangeFinder<M, T> pageByIndexFinderCommand, int listSize) {
            FindListMultiModeResponse<M, K, T> result = new FindListMultiModeResponse<M, K, T>();
            result.setListSize(listSize);
            result.setListSizeFinderCommand(listSizeFinderCommand);
            result.setPageByIndexRangeFinder(pageByIndexFinderCommand);
            result.setPaginationMode(ListCache.PaginationMode.PAGE_BY_INDEX_RANGE);
            result.setRejected(false);
            return result;
        }

        public boolean getRejected() {
            return this.rejected;
        }

        public void setRejected(boolean rejected) {
            this.rejected = rejected;
        }

        public String getFailureResultName() {
            return this.failureResultName;
        }

        public void setFailureResultName(String value) {
            this.failureResultName = value;
        }

        public String getSuccessResultName() {
            return this.successResultName;
        }

        public void setSuccessResultName(String value) {
            this.successResultName = value;
        }

        public String getSuccessSingleForwardName() {
            return this.successSingleForwardName;
        }

        public void setSuccessSingleForwardName(String successSingleForwardName) {
            this.successSingleForwardName = successSingleForwardName;
        }

        public ListFinder<M, T> getFullListFinderCommand() {
            return this.fullListFinderCommand;
        }

        public void setFullListFinderCommand(ListFinder<M, T> fullListFinderCommand) {
            this.fullListFinderCommand = fullListFinderCommand;
        }

        public List<T> getFullList() {
            return this.fullList;
        }

        public void setFullList(List<T> fullList) {
            this.fullList = fullList;
        }

        public IdListFinder<M, K> getIdListFinderCommand() {
            return this.idListFinderCommand;
        }

        public void setIdListFinderCommand(IdListFinder<M, K> idListFinderCommand) {
            this.idListFinderCommand = idListFinderCommand;
        }

        public List<K> getIdList() {
            return this.idList;
        }

        public void setIdList(List<K> idList) {
            this.idList = idList;
        }

        public ListSizeFinder<M> getListSizeFinderCommand() {
            return this.listSizeFinderCommand;
        }

        public void setListSizeFinderCommand(ListSizeFinder<M> listSizeFinderCommand) {
            this.listSizeFinderCommand = listSizeFinderCommand;
        }

        public PageByIndexRangeFinder<M, T> getPageByIndexRangeFinder() {
            return this.pageByIndexRangeFinder;
        }

        public void setPageByIndexRangeFinder(PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
            this.pageByIndexRangeFinder = pageByIndexRangeFinder;
        }

        public Integer getListSize() {
            return this.listSize;
        }

        public void setListSize(Integer listSize) {
            this.listSize = listSize;
        }

        public boolean getUseSuccessSingle() {
            return this.useSuccessSingle;
        }

        public void setUseSuccessSingle(boolean useSuccessSingle) {
            this.useSuccessSingle = useSuccessSingle;
        }

        public ListCache.PaginationMode getPaginationMode() {
            return this.paginationMode;
        }

        public void setPaginationMode(ListCache.PaginationMode paginationMode) {
            this.paginationMode = paginationMode;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }

        public void setErrors(Collection<String> errors) {
            this.errors = errors;
        }

        public Collection<String> getMessages() {
            return this.messages;
        }

        public void setMessages(Collection<String> messages) {
            this.messages = messages;
        }

        public void addErrorMessage(String text) {
            this.errors.add(text);
        }

        public void addInfoMessage(String text) {
            this.messages.add(text);
        }
    }
}

