package name.matthewgreet.strutscommons.view;

import java.util.ArrayList;
import java.util.List;

/**
 * <P>Aids creation of OPTION tags in JSPs for SELECT elements by formatting group headers for display.  It may 
 *    optionally contain group header data.</P>
 *    
 * @param <K> Unique identifier for instance of T.
 * @param <T> Unformatted record.
 * @param <G> Unformatted group that instances of T can be a member, which can even be String.
 */
public class SelectBoxGroupDisplay<K,T,G>  {
    private String text;
    private G data;
    private List<SelectBoxItemDisplay2<K,T>> children;
    
    public SelectBoxGroupDisplay() {
        text = "";
        data = null;
        children = new ArrayList<SelectBoxItemDisplay2<K,T>>();
    }
    
    public SelectBoxGroupDisplay(String text) {
        setModel(text);
    }
    
    public SelectBoxGroupDisplay(String text, G data) {
        setModel(text, data);
    }
    
    
    public void setModel(String text) {
        this.text 		= text;
        this.data 		= null;
        this.children = new ArrayList<SelectBoxItemDisplay2<K,T>>();
    }

    public void setModel(String text, G data) {
        this.text 		= text;
        this.data 		= data;
        this.children = new ArrayList<SelectBoxItemDisplay2<K,T>>();
    }

    /**
     * Returns text displayed in web page. 
     */
    public String getText() {
        return text;
    }
    public void setText(String value) {
        this.text = value;
    }
    
    /**
     * Returns raw model group header that is being formatted for display. 
     */
    public G getData() {
        return data;
    }
    public void setData(G value) {
        this.data = value;
    }

	public List<SelectBoxItemDisplay2<K,T>> getChildren() {
		return children;
	}
	public void setChildren(List<SelectBoxItemDisplay2<K,T>> children) {
		this.children = children;
	}
    

    
}
