package name.matthewgreet.strutscommons.view;

import java.util.Comparator;

/**
 * <P>Concrete subclass of {@link SingleSelectBoxDisplay} that formats list of numbers for display in an HTML select 
 * box.  The raw list, as set in the <CODE>model</CODE> property, should be a collection of <CODE>Integer</CODE>. See
 * {@link SingleSelectBoxDisplay2}.</P>
 */
public class IntegerListSelectBoxDisplay2 extends SingleSelectBoxDisplay2<Integer,Integer> {
    public class NumberComparator implements Comparator<SelectBoxItemDisplay2<Integer,Integer>> {
        public int compare(SelectBoxItemDisplay2<Integer,Integer> o1, SelectBoxItemDisplay2<Integer,Integer> o2) {
            Integer item1, item2;
            
            item1 = o1.getData();
            item2 = o2.getData();
            return item1.compareTo(item2);
        }
    }

    /**
     * Returns comparator that compares number items by value.  May be
     * overridden for a different order.
     */
    @Override
    protected Comparator<SelectBoxItemDisplay2<Integer,Integer>> getSortComparator() {
        return new NumberComparator();
    }
    
	@Override
	protected Integer getKey(Integer item) {
		return item;
	}

    /**
     * Converts number to select box item value.
     */
    @Override
    protected String getValue(Integer item) {
        return item.toString();
    }

    /**
     * Converts number to select box item display text.
     */
    @Override
    protected String getText(Integer item) {
        return item.toString();
    }
}
