package name.matthewgreet.strutscommons.util;

import java.io.Serializable;

/**
 * Strategy for finding single item.
 * 
 * @param <K> Type of key that identifies record.
 * @param <T> Record type.
 */
@FunctionalInterface
public interface SingleItemFinder<K extends Serializable,T extends Serializable> extends Serializable {
    
    /**
     * Retrieves item from primary key or id, or null if not found.   
     */
    public T getItem(K key) throws Exception;
}
