package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.Comparator;

/**
 * Comparator used by {@link ListCache}. 
 */
@FunctionalInterface
public interface ListCacheRecordComparator<T> extends Comparator<T>,Serializable {
	/**
	 * Returns whether this comparator uses data that must be loaded by a page extension assembler.  This is only used
	 * in base record pagination mode.
	 */
	default public boolean usesPageExtensionData() {
		return true;
	}
}
