package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.List;

/**
 * <P>Strategy for finding list of ids or other primary keys.  This is useful for pages using pagination with some 
 * instance of {@link PageByIdsFinder} lazy loading the current page.</P>
 * 
 * @param <M> Record type of master list or NA if finding for the master list.
 * @param <K> Record primary key or id type returned by this finder.
 */
@FunctionalInterface
public interface IdListFinder<M extends Serializable,K extends Serializable> extends Serializable {
    
    /**
     * Returns list of ids of record according to implementing search criteria.  Null may be returned if nothing found.
     * 
     * @param selectedMaster Selected record in master list or null for loading master list.
     */
    public List<K> getIds(M selectedMaster) throws Exception;
}
