package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class RequiredValidator extends AbstractNonConversionValidatorSupport<Required> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
		return true;
	}

    @Override
    public ValidationResult validate(String formValue) throws Exception {
        if (formValue.length() > 0) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
