package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;

/**
 * Interface for form field validators used by {@link AnnotationValidationInterceptor} and 
 * {@link AnnotationValidationInterceptor2} that check a converted value. 
 */
@SuppressWarnings("deprecation")
public interface PostConversionValidator<A extends Annotation,T> extends Policy<A> {
    /**
     * Returns whether to write any error message to action errors, field errors, or action messages. 
     */
    public MessageType getMessageType();
    
    /**
     * Returns message set by annotation.  Used if {@link #getMessageKey} is empty string or it fails to find a message. 
     */
    public String getMessage();
    
    /**
     * Returns message key set by annotation, which is used to retrieve message from Action's TextProvider if it's not 
     * empty string. 
     */
    public String getMessageKey();
    
    /**
     * Returns type of recipient fields that can receive converted form value. 
     */
    public Class<T> getRecipientClass();
    
    /**
     * Returns whether rejection by this validator should stop further validation. 
     */
    public boolean getShortCircuit();
    
    /**
     * Returns whether validator should not be skipped if conversion failed or was skipped. 
     */
    public boolean getProcessNoValue();
    
    /**
     * Returns result of checking converted form field value and message to use if failed.  This is not called if the 
     * form value is empty string or null or the conversion failed.
     */
    public ValidationResult validate(T formValue) throws Exception;

}
