package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;


/**
 * Interface for post conversion adjusters, which alter form field values and used by 
 * {@link AnnotationValidationInterceptor2} (not {@link AnnotationValidationInterceptor}).  This is useful for adding 
 * implied values, such as midnight time for a date.  Post conversion adjusters are run after conversion but before post 
 * conversion validators.  
 */
@SuppressWarnings("deprecation")
public interface PostConversionAdjuster<A extends Annotation,T> extends Policy<A> {
    /**
     * Returns type of recipient fields that can receive converted form value. 
     */
    public Class<T> getRecipientClass();
    
    /**
     * Returns whether validator should not be skipped if conversion failed or was skipped. 
     */
    public boolean getProcessNoValue();
    
    /**
     * Returns adjusted form field value. 
     */
    public T adjust(T formValue) throws Exception;

}
