package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class MaxLengthValidator extends AbstractNonConversionValidatorSupport<MaxLength> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public ValidationResult validate(String formValue) throws Exception {
        String workingValue;
        
        workingValue = formValue;
        if (getAnnotation().trim()) {
            workingValue = workingValue.trim();
        }
        if (workingValue.length() <= getAnnotation().maxLength()) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
