package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class LongConverter extends AbstractDefaultConverterSupport<LongConversion,Long> {
    private static final Logger LOG = LogManager.getLogger(LongConverter.class);
    
    @LongConversion
    private static boolean annotationPlaceholder;

	@Override
	protected LongConversion makeDefaultAnnotation() {
		try {
			return LongConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(LongConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Long unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Long> getRecipientClass() {
        return Long.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Long> convert(String formValue, Class<? extends Long> recipientClass) throws Exception {
        long parsedValue;
        
        try {
            parsedValue = Long.parseLong(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
