package name.matthewgreet.strutscommons.policy;

import java.util.Collection;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.IntegerCSVConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class IntegerCSVConverter extends AbstractDefaultCollectionConverterSupport<IntegerCSVConversion,Integer> {
    private static final Logger LOG = LogManager.getLogger(IntegerCSVConverter.class);
    
    @IntegerCSVConversion
    private static boolean annotationPlaceholder;

	@Override
	protected IntegerCSVConversion makeDefaultAnnotation() {
		try {
			return IntegerCSVConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(IntegerCSVConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Collection<Integer> unformattedValues) throws Exception {
        String result;
        
        result = "";
        for (Integer value: unformattedValues) {
            if (result.length() > 0) {
                result = result + getAnnotation().separator();
            }
            if (value != null) {
            	result = result + Integer.toString(value);
            }
        }
        return result;
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<?> recipientFieldClass, Class<? extends Integer> recipientClass) throws Exception {
        Collection<Integer> parsedValue;
        String[] values;
        String trimmedValue;
        
        parsedValue = makeCollectionForRecipient(recipientFieldClass);
        try {
        	if (formValue.trim().length() > 0) {
	            values = formValue.split(getAnnotation().separator(), -1);
	            for (String value: values) {
	            	trimmedValue = value.trim();
	            	if (trimmedValue.length() > 0) {
	            		parsedValue.add(Integer.parseInt(trimmedValue));
	            	} else {
	            		parsedValue.add(null);
	            	}
	            }
        	}
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
        return ConversionResult.makeSuccessCollectionResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
