package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class FloatConverter extends AbstractDefaultConverterSupport<FloatConversion,Float> {
    private static final Logger LOG = LogManager.getLogger(FloatConverter.class);
    
    @FloatConversion
    private static boolean annotationPlaceholder;

	@Override
	protected FloatConversion makeDefaultAnnotation() {
		try {
			return FloatConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(FloatConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Float unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Float> getRecipientClass() {
        return Float.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Float> convert(String formValue, Class<? extends Float> recipientClass) throws Exception {
    	float parsedValue;
        
        try {
            parsedValue = Float.parseFloat(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
