package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class CharacterConverter extends AbstractDefaultConverterSupport<CharacterConversion,Character> {
    private static final Logger LOG = LogManager.getLogger(CharacterConverter.class);
    
    @CharacterConversion
    private static boolean annotationPlaceholder;

	@Override
	protected CharacterConversion makeDefaultAnnotation() {
		try {
			return CharacterConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(CharacterConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Character unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Character> getRecipientClass() {
        return Character.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Character> convert(String formValue, Class<? extends Character> recipientClass) throws Exception {
        char parsedValue;
        
        parsedValue = formValue.charAt(0);
        return ConversionResult.makeSuccessResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
