package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class ByteConverter extends AbstractDefaultConverterSupport<ByteConversion,Byte> {
    private static final Logger LOG = LogManager.getLogger(ByteConverter.class);
    
    @ByteConversion
    private static boolean annotationPlaceholder;

	@Override
	protected ByteConversion makeDefaultAnnotation() {
		try {
			return ByteConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(ByteConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Byte unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Byte> getRecipientClass() {
        return Byte.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Byte> convert(String formValue, Class<? extends Byte> recipientClass) throws Exception {
        byte parsedValue;
        
        try {
            parsedValue = Byte.parseByte(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
