package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;


/**
 * Interface for adjusters, which alter form field values and used by {@link AnnotationValidationInterceptor} and 
 * {@link AnnotationValidationInterceptor2}.  Adjusters are run before any validators or converters.  
 */
@SuppressWarnings("deprecation")
public interface Adjuster<A extends Annotation> extends Policy<A> {
    /**
     * Returns adjusted form field value. 
     */
    public String adjust(String fieldValue) throws Exception;

    /**
     * Returns whether adjuster should not be skipped if the form field value is empty string. 
     */
    public boolean getProcessNoValue();
    
}
