package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

/**
 * Preferred template class for implementations of converters to single value data type that can be default converters. 
 */
public abstract class AbstractDefaultConverterSupport<A extends Annotation,T> extends AbstractConverterSupport<A,T> implements DefaultPolicy {
	protected abstract A makeDefaultAnnotation();
	
    public A getAnnotation() {
    	A result;
    	
    	result = super.getAnnotation();
    	if (result == null) {
    		result = makeDefaultAnnotation();
    		super.setAnnotation(result);
    	}
        return result;
    }

}
