package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CustomPostConversionValidation;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Template class for client supplied validators that validates a converted form field value that are single values.  
 * Subclasses must implement {@link #getRecipientClass} and {@link #validate #validate}.   
 */
public abstract class AbstractCustomPostConversionValidatorSupport<T> extends AbstractPostConversionValidatorSupport<CustomPostConversionValidation,T> {
    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }
    
	@Override
	public boolean getProcessNoValue() {
		return getAnnotation().processNoValue();
	}

}
