package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;

/**
 * Template class for client supplied converters to collection-based data types that just format for a view helper.  
 * Subclasses must implement {@link #getRecipientClass} and {@link #format #format}.   
 */
public abstract class AbstractCustomCollectionFormatterSupport<T> extends AbstractCustomCollectionConverterSupport<T> {
	@Override
    public ConversionResult<T> convert(String formValue, Class<?> recipientFieldClass, Class<? extends T> recipientClass) {
    	return ConversionResult.makeSkippedCollectionResult(InterceptorCommonLibrary.makeCollectionForRecipient(recipientClass));
    }

	@Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getProcessNoValue() {
    	return getAnnotation().processNoValue();
    }
    
}
