package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;
import java.util.Collection;

import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;

/**
 * Preferred template class for implementations of converters to collection-based data types. 
 */
public abstract class AbstractCollectionConverterSupport<A extends Annotation,T> extends AbstractPolicySupport<A> implements CollectionConverter<A,T> {

    protected Collection<T> makeCollectionForRecipient(Class<?> recipientFieldClass) {
        return InterceptorCommonLibrary.makeCollectionForRecipient(recipientFieldClass);
    }
    
}
