package name.matthewgreet.strutscommons.form;

import java.io.Serializable;
import java.util.Map;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.action.ValidationAware2;
import name.matthewgreet.strutscommons.annotation.ManualParameterConversion;


/**
 * Template for class that receives form data for form driven Actions.
 */
@SuppressWarnings("deprecation")
public abstract class AbstractForm implements Form, Serializable {
    private static final long serialVersionUID = -7073882751478034447L;


    public AbstractForm() {
        resetFields();
    }
	
    /**
     * Sets all displayed fields to default values for data entry of a new record, which is usually an empty string.
     */
    public void resetFields() {
    	// Empty
    }
    

    /**
     * Validates and parses form data itself, such as required fields or date validation, writing any error or field 
     * messages to the ValidationAware message receiver.  Any error message indicates a failure.  
     * 
     * @param validationAware Error message receiver, usually the calling action. 
     * @param textProvider Message name translator that generates localised text, if this is set up.  This is usually
     *                     ignored as no localisation is set up.
     *                     
     * @deprecated Replaced by {@link #doValidate2 #doValidate2}, which can recognise warning messages.
     */
    @Deprecated
    public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
    	// Empty
    }

    /**
     * Validates and parses form data itself, such as required fields or date validation, writing any error or field 
     * messages to the ValidationAware2 message receiver.  Any error message indicates a failure..
     * 
     * @param validationAware Error message receiver, usually the calling action. 
     * @param textProvider Message name translator that generates localised text, if this is set up.  This is usually
     *                     ignored as no localisation is set up.
     */
    public void doValidate2(ValidationAware2 validationAware, TextProvider textProvider) {
        // Empty
    }

	/**
	 * <P>Sets, converts and validates form fields from unprocessed request parameters, writes any error messages, and 
	 * returns the names of successfully processed parameters and unsuccessfully processed parameters.  Where multiple 
	 * request parameters have the same name, only the first is presented.</P>
	 * 
	 * <P>Unprocessed parameters are those that haven't set a form field for a number of reasons.</P>
	 * <UL>
	 *   <LI>No form field has the same name.</LI>
	 *   <LI>Form field is annotated with {@link ManualParameterConversion}.</LI>
	 *   <LI>Form field is a non-string array type.</LI>
	 * </UL>
	 */
	public ManualParameterConversionResult manualParameterConvert(Map<String,String> unprocessedParameters,
			ValidationAware validationAware, TextProvider textProvider) {
		return new ManualParameterConversionResult();
	}
}
