package name.matthewgreet.strutscommons.exception;

import name.matthewgreet.strutscommons.policy.Policy;

/**
 * Base exception describing that an update to a policy lookup failed.
 */
public class PolicyLookupRejectionException extends Exception {
	private static final long serialVersionUID = -121412323815834849L;
	
	private Class<? extends Policy<?>> policyClass; 

	public PolicyLookupRejectionException(String message, Class<? extends Policy<?>> policyClass) {
		super(message);
		this.policyClass = policyClass;
	}

	/**
	 * Returns policy class that cannot be added or removed. 
	 */
	public Class<? extends Policy<?>> getPolicyClass() {
		return policyClass;
	}

}
