package name.matthewgreet.strutscommons.exception;

import name.matthewgreet.strutscommons.policy.Policy;

/**
 * Exception describing that a policy cannot be added as it's an interface or abstract class, not an implementing class.
 */
public class NotPolicyImplementationException extends PolicyLookupRejectionException {
	private static final long serialVersionUID = -3965190892864532822L;

	public NotPolicyImplementationException(Class<? extends Policy<?>> policyClass) {
		super("Class is an interface or abstract class  class=" + policyClass, policyClass);
	}

}
