package name.matthewgreet.strutscommons.exception;

import name.matthewgreet.strutscommons.policy.Policy;

/**
 * Exception describing that a custom policy cannot be added.  Custom annotations already refer to their implementing 
 * policy.
 */
public class CustomPolicyNotApplicableException extends PolicyLookupRejectionException {
	private static final long serialVersionUID = -3965190892864532822L;

	public CustomPolicyNotApplicableException(Class<? extends Policy<?>> policyClass) {
		super("Policy is for a custom annotation, which does not use policy lookup  class=" + policyClass, policyClass);
	}

}
