package name.matthewgreet.strutscommons.exception;

import name.matthewgreet.strutscommons.policy.Policy;

/**
 * Exception indicating a converter or collection converter could not be added because it's not a default converter or 
 * default collection converter.
 */
public class ConverterNotDefaultException extends PolicyLookupRejectionException {
	private static final long serialVersionUID = -3965190892864532822L;

	public ConverterNotDefaultException(Class<? extends Policy<?>> policyClass) {
		super("Converter or collection converter is not marked as a default converter or collection converter  class=" + policyClass, policyClass);
	}

}
