package name.matthewgreet.strutscommons.action;

import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.interceptor.FormFormatterInterceptor;
import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

/**
 * Template class for Struts 2 actions that display something.  Concrete subclasses are expected to use an interceptor 
 * stack like <CODE>ViewStack</CODE>; see <A HREF="../interceptor/package-summary.html">interceptor package</A>.

 */
public abstract class AbstractViewActionSupport extends AbstractActionSupport {
    private static final long serialVersionUID = -6301561599589248089L;
    
    /**
     * <P>For all the current Action's forms, formats the annotated, formatted halves of every formatted/unformatted 
     * field pair from the unformatted halves, except for any form that was retrieved and injected (usually a rejected 
     * form).  See {@link BooleanConversion}, {@link EnumConversion}, {@link IntegerConversion} etc.</P>
     * 
     * <P>This is a legacy function and is called by view Struts Actions that don't use the 
     *    {@link FormFormatterInterceptor} interceptor.</P>
     */
    protected void formatForms() {
    	StrutsMiscellaneousLibrary.formatForms();
    }

}
