package name.matthewgreet.strutscommons.action;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.Logger;
import org.apache.struts2.action.ServletRequestAware;

import com.opensymphony.xwork2.ActionSupport;


/**
 * <P>Base class of Struts 2 Action that supports server state per browser tab.</P>
 */
@SuppressWarnings("deprecation")
public abstract class AbstractActionSupport extends ActionSupport implements BrowserTabAware,BrowserTabAware2,LoggingAware,ServletRequestAware,ValidationAware2 {
    private static final long serialVersionUID = -1896040234881019933L;

    private BrowserTabSession browserTabSession;
    private Collection<String> actionWarnings = new ArrayList<>();
    private HttpServletRequest servletRequest;
    private String tabId;

    
    /**
     * Returns logger for recording events, which should be overridden by the implementing subclass.
     */
    public abstract Logger getLogger();
    
    /**
     * Returns browser tab id, distinguishing between browser tabs on the same web browser.
     * 
     * @deprecated Suffers from a design flaw of not handling when a user opens a link in a new tab.  Obtain the 
     * {@link BrowserTabSession} instance using {@link #getBrowserTabSession} and place session objects in that.
     */
    @Deprecated
	@Override
    public String getTabId() {
    	return tabId;
    }
    /**
     * Sets browser tab id, distinguishing between browser tabs on the same web browser.
     * 
     * @deprecated Suffers from a design flaw of not handling when a user opens a link in a new tab.  Obtain the 
     * {@link BrowserTabSession} instance using {@link #getBrowserTabSession} and place session objects in that.
     */
    @Deprecated
	@Override
    public void setTabId(String value) {
    	tabId = value;
    }
    
    /**
     * Returns a session that distinguishes between different tabs of the same web browser.
     */
	@Override
    public BrowserTabSession getBrowserTabSession() {
    	return browserTabSession;
    }
    /**
     * Sets a session that distinguishes between different tabs of the same web browser.
     */
	@Override
    public void setBrowserTabSession(BrowserTabSession value) {
    	this.browserTabSession = value;
    }
    
    @Override
    public Collection<String> getActionWarnings() {
        return actionWarnings;
    }
    
    @Override
    public void setActionWarnings(Collection<String> messages) {
        this.actionWarnings = messages;
    }
    
    @Override
    public void addActionWarning(String message) {
        actionWarnings.add(message);
    }
    
    @Override
    public boolean hasActionWarnings() {
        return !actionWarnings.isEmpty();
    }
    
    public HttpServletRequest getServletRequest() {
        return servletRequest;
    }
	@Override
	public void withServletRequest(HttpServletRequest request) {
		this.servletRequest = request;
	}


}
