/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletLibrary {
    public static final String OLD_TAB_ID_COOKIE_NAME = "_OldTabId";
    public static final String TAB_ID_COOKIE_NAME = "_TabId";
    public static final String SET_TAB_ID_COOKIE_NAME = "_SetTabId";
    public static final String COOKIE_NAME_POPUP_MARKER = "_popup_";

    public static String getBrowserOldTabId(Cookie[] cookies) {
        String result = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(OLD_TAB_ID_COOKIE_NAME)) continue;
                result = cookie.getValue();
                break;
            }
        }
        return result;
    }

    public static String getBrowserTabId(Cookie[] cookies) {
        String result = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(TAB_ID_COOKIE_NAME)) continue;
                result = cookie.getValue();
                break;
            }
        }
        if (result != null && result.contains(COOKIE_NAME_POPUP_MARKER)) {
            result = result.substring(result.indexOf(COOKIE_NAME_POPUP_MARKER) + COOKIE_NAME_POPUP_MARKER.length());
        }
        return result;
    }

    public static String getGuaranteedBrowserTabId(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        String result = ServletLibrary.getBrowserTabId(cookies);
        String string = result = result != null ? result : "";
        if (result.length() == 0) {
            Cookie newCookie = (Cookie)request.getSession().getAttribute(TAB_ID_COOKIE_NAME);
            if (newCookie == null) {
                newCookie = ServletLibrary.makeSetTabIdCookie();
                request.getSession().setAttribute(TAB_ID_COOKIE_NAME, (Object)newCookie);
            }
            response.addCookie(newCookie);
            result = newCookie.getValue();
        }
        return result;
    }

    public static Cookie makeSetTabIdCookie() {
        Cookie result = new Cookie(SET_TAB_ID_COOKIE_NAME, Long.toString(System.currentTimeMillis()));
        result.setPath("/");
        return result;
    }
}

