/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import java.util.Collection;
import name.matthewgreet.strutscommons.annotation.IntegerCSVConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultCollectionConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegerCSVConverter
extends AbstractDefaultCollectionConverterSupport<IntegerCSVConversion, Integer> {
    private static final Logger LOG = LogManager.getLogger(IntegerCSVConverter.class);
    @IntegerCSVConversion
    private static boolean annotationPlaceholder;

    @Override
    protected IntegerCSVConversion makeDefaultAnnotation() {
        try {
            return IntegerCSVConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(IntegerCSVConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Collection<Integer> unformattedValues) throws Exception {
        String result = "";
        for (Integer value : unformattedValues) {
            if (result.length() > 0) {
                result = result + ((IntegerCSVConversion)this.getAnnotation()).separator();
            }
            if (value == null) continue;
            result = result + Integer.toString(value);
        }
        return result;
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((IntegerCSVConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((IntegerCSVConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((IntegerCSVConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((IntegerCSVConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<?> recipientFieldClass, Class<? extends Integer> recipientClass) throws Exception {
        Collection parsedValue = this.makeCollectionForRecipient(recipientFieldClass);
        try {
            if (formValue.trim().length() > 0) {
                String[] values;
                for (String value : values = formValue.split(((IntegerCSVConversion)this.getAnnotation()).separator(), -1)) {
                    String trimmedValue = value.trim();
                    if (trimmedValue.length() > 0) {
                        parsedValue.add(Integer.parseInt(trimmedValue));
                        continue;
                    }
                    parsedValue.add(null);
                }
            }
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
        return ConversionResult.makeSuccessCollectionResult(parsedValue);
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

