/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import com.opensymphony.xwork2.ActionContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateConverter
extends AbstractDefaultConverterSupport<DateConversion, Date> {
    private static final Logger LOG = LogManager.getLogger(DateConverter.class);
    @DateConversion
    private static boolean annotationPlaceholder;

    @Override
    protected DateConversion makeDefaultAnnotation() {
        try {
            return DateConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(DateConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    public static int getDateFormatStyle(DateConversion.Style style) {
        switch (style) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        return 3;
    }

    public static int getTimeFormatStyle(DateConversion.TimeStyle style) {
        switch (style) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case NONE: {
                return 3;
            }
        }
        return 3;
    }

    protected TimeZone getTimeZone() {
        TimeZone result = null;
        if (((DateConversion)this.getAnnotation()).timezone().length() > 0) {
            result = TimeZone.getTimeZone(((DateConversion)this.getAnnotation()).timezone());
        } else if (((DateConversion)this.getAnnotation()).actionContextTimeZone().length() > 0) {
            try {
                result = (TimeZone)ActionContext.getContext().get(((DateConversion)this.getAnnotation()).actionContextTimeZone());
            }
            catch (ClassCastException e) {
                LOG.warn("DateConversion actionContextTimeZone parameter refers to non-TimeZone  action=" + ActionContext.getContext().getActionName() + "  actionContextTimeZone=" + ((DateConversion)this.getAnnotation()).actionContextTimeZone());
            }
        }
        if (result == null) {
            result = TimeZone.getDefault();
        }
        return result;
    }

    protected DateFormat makeDateFormat() {
        DateFormat result;
        if (((DateConversion)this.getAnnotation()).format().length() > 0) {
            result = new SimpleDateFormat(((DateConversion)this.getAnnotation()).format());
        } else {
            Locale locale = ((DateConversion)this.getAnnotation()).localeCountry().length() > 0 && ((DateConversion)this.getAnnotation()).localeLanguage().length() > 0 ? new Locale(((DateConversion)this.getAnnotation()).localeLanguage(), ((DateConversion)this.getAnnotation()).localeCountry()) : ActionContext.getContext().getLocale();
            result = ((DateConversion)this.getAnnotation()).timeStyle() != DateConversion.TimeStyle.NONE ? DateFormat.getDateTimeInstance(DateConverter.getDateFormatStyle(((DateConversion)this.getAnnotation()).style()), DateConverter.getTimeFormatStyle(((DateConversion)this.getAnnotation()).timeStyle()), locale) : DateFormat.getDateInstance(DateConverter.getDateFormatStyle(((DateConversion)this.getAnnotation()).style()), locale);
        }
        result.setLenient(false);
        TimeZone timeZone = this.getTimeZone();
        result.setTimeZone(timeZone);
        return result;
    }

    @Override
    public String format(Date unformattedValue) throws Exception {
        DateFormat formatter = this.makeDateFormat();
        return formatter.format(unformattedValue);
    }

    @Override
    public Class<Date> getRecipientClass() {
        return Date.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((DateConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((DateConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((DateConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((DateConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Date> convert(String formValue, Class<? extends Date> recipientClass) throws Exception {
        try {
            DateFormat formatter = this.makeDateFormat();
            Date parsedValue = formatter.parse(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (ParseException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

