/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnhandledExceptionWriterInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -1257373050470853612L;
    private Logger logger;
    private boolean disabledChangeResult = false;
    private boolean disabledErrorMessage = false;
    private String applicationErrorMessage = "The action was rejected: ${e}";
    private String systemFailureErrorMessage = "A system failure occurred, which was logged";

    protected void checkLogger(ActionInvocation invocation) {
        if (this.logger == null) {
            this.logger = this.makeLogger(invocation);
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected boolean isSystemFailureException(Exception e) {
        return e instanceof RuntimeException;
    }

    protected void logException(ActionInvocation invocation, boolean isSystemFailure, Exception e) {
        String message = isSystemFailure ? "Uncaught system failure" : "Uncaught application rejection";
        this.getLogger().error(message, (Throwable)e);
    }

    protected Logger makeLogger(ActionInvocation invocation) {
        return LogManager.getLogger((String)invocation.getAction().getClass().getName());
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        try {
            return invocation.invoke();
        }
        catch (Exception e) {
            boolean isSystemFailure = this.isSystemFailureException(e);
            if (!this.disabledErrorMessage && invocation.getAction() instanceof ValidationAware) {
                ValidationAware validationAware = (ValidationAware)invocation.getAction();
                String errorMessage = isSystemFailure ? this.systemFailureErrorMessage : this.applicationErrorMessage;
                errorMessage = errorMessage.replace("${e}", e.getMessage() != null ? e.getMessage() : "");
                validationAware.addActionError(errorMessage);
            }
            if (!this.disabledChangeResult) {
                this.checkLogger(invocation);
                this.logException(invocation, isSystemFailure, e);
                if (isSystemFailure) {
                    return "error";
                }
                return "input";
            }
            throw e;
        }
    }

    public boolean getDisabledChangeResult() {
        return this.disabledChangeResult;
    }

    public void setDisabledChangeResult(boolean disabledChangeResult) {
        this.disabledChangeResult = disabledChangeResult;
    }

    public boolean getDisabledErrorMessage() {
        return this.disabledErrorMessage;
    }

    public void setDisabledErrorMessage(boolean disabledErrorMessage) {
        this.disabledErrorMessage = disabledErrorMessage;
    }

    public String getApplicationErrorMessage() {
        return this.applicationErrorMessage;
    }

    public void setApplicationErrorMessage(String applicationErrorMessage) {
        this.applicationErrorMessage = applicationErrorMessage;
    }

    public String getSystemFailureErrorMessage() {
        return this.systemFailureErrorMessage;
    }

    public void setSystemFailureErrorMessage(String systemFailureErrorMessage) {
        this.systemFailureErrorMessage = systemFailureErrorMessage;
    }
}

