/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import name.matthewgreet.strutscommons.action.ValidationAware2;
import name.matthewgreet.strutscommons.interceptor.MessageStoreInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageRetrieveInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6513506646328167140L;
    private Logger LOG = LogManager.getLogger(MessageRetrieveInterceptor.class);
    private boolean disabled;

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object rawObject;
        if (!this.disabled && invocation.getAction() instanceof ValidationAware && (rawObject = ActionContext.getContext().getSession().get(MessageStoreInterceptor.SESSION_STORED_MESSAGES)) != null) {
            if (rawObject instanceof MessageStoreInterceptor.StoredMessages) {
                MessageStoreInterceptor.StoredMessages storedMessages = (MessageStoreInterceptor.StoredMessages)rawObject;
                ValidationAware validationAware = (ValidationAware)invocation.getAction();
                validationAware.setActionErrors(storedMessages.getActionErrors());
                validationAware.setActionMessages(storedMessages.getActionMessages());
                validationAware.setFieldErrors(storedMessages.getFieldErrors());
                if (invocation.getAction() instanceof ValidationAware2) {
                    ValidationAware2 validationAware2 = (ValidationAware2)invocation.getAction();
                    validationAware2.setActionWarnings(storedMessages.getActionWarnings());
                }
                ActionContext.getContext().getSession().remove(MessageStoreInterceptor.SESSION_STORED_MESSAGES);
            } else {
                this.LOG.warn("Session attribute are not stored messages  session attribute=" + MessageStoreInterceptor.SESSION_STORED_MESSAGES + "  value=" + rawObject);
            }
        }
        return invocation.invoke();
    }
}

